/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.telemetry.ITelemetryDataProvider;
import org.pentaho.telemetry.TelemetryEvent;
import org.pentaho.telemetry.TelemetryEventKeeper;
import org.pentaho.telemetry.TelemetryEventSender;

public class TelemetryHelper {
    private static Log logger;
    protected static final BlockingQueue<TelemetryEvent> requestQueue;
    private ITelemetryDataProvider dataProvider;
    private static final ScheduledThreadPoolExecutor threadPoolExecutor;

    protected static String getTelemetryPath() {
        return PentahoSystem.getApplicationContext().getSolutionPath("system/.telemetry");
    }

    protected static String getLastSubmissionsPath() {
        return PentahoSystem.getApplicationContext().getSolutionPath("system/.telemetry/lastsubmission");
    }

    public void setDataProvider(ITelemetryDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public boolean publishTelemetryEvent() {
        if (!this.isTelemetryEnabled()) {
            logger.info((Object)"Telemetry was not enabled for this server installation");
            return false;
        }
        return this.sendRequest(new TelemetryEvent(this.dataProvider));
    }

    protected boolean sendRequest(TelemetryEvent te) {
        return requestQueue.offer(te);
    }

    private boolean isTelemetryEnabled() {
        if (this.dataProvider != null) {
            return this.dataProvider.isTelemetryEnabled();
        }
        return false;
    }

    static {
        String lastSubmissionPath;
        File lastSubmissionDir;
        logger = LogFactory.getLog(TelemetryHelper.class);
        requestQueue = new ArrayBlockingQueue<TelemetryEvent>(100);
        threadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Telemetry Event Sender Thread");
                t.setDaemon(true);
                return t;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
        String telemetryPath = TelemetryHelper.getTelemetryPath();
        File telemetryDir = new File(telemetryPath);
        if (!telemetryDir.exists()) {
            telemetryDir.mkdir();
        }
        if (!(lastSubmissionDir = new File(lastSubmissionPath = TelemetryHelper.getLastSubmissionsPath())).exists()) {
            lastSubmissionDir.mkdir();
        }
        threadPoolExecutor.scheduleAtFixedRate(new TelemetryEventSender(lastSubmissionDir, telemetryDir), 0L, 24L, TimeUnit.HOURS);
        Thread requestThread = new Thread(new TelemetryEventKeeper(requestQueue, telemetryPath));
        requestThread.setName("Telemetry Event keeper Thread");
        requestThread.setDaemon(true);
        requestThread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TelemetryEventType {
        INSTALLATION,
        REMOVAL,
        USAGE,
        OTHER;

    }
}

