/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import pt.webdetails.cpf.annotations.AccessLevel;
import pt.webdetails.cpf.annotations.Exposed;
import pt.webdetails.cpf.annotations.OutputType;

public class SimpleContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 1L;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void createContent() {
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", "", this.instanceId, "text/html");
        try {
            OutputStream out = contentItem.getOutputStream(null);
            Class[] params = new Class[]{OutputStream.class};
            String[] pathSections = StringUtils.split((String)pathParams.getStringParameter("path", null), (String)"/");
            if (pathSections != null && pathSections.length > 0) {
                String method = StringUtils.lowerCase((String)pathSections[0]);
                try {
                    String outputType;
                    Method mthd = ((Object)((Object)this)).getClass().getMethod(method, params);
                    boolean exposed = mthd.isAnnotationPresent(Exposed.class);
                    boolean accessible = exposed && mthd.getAnnotation(Exposed.class).accessLevel() == AccessLevel.PUBLIC;
                    boolean outputTypePresent = mthd.isAnnotationPresent(OutputType.class);
                    String string = outputType = outputTypePresent ? mthd.getAnnotation(OutputType.class).value() : "";
                    if (outputTypePresent) {
                        this.setResponseHeaders(outputType, null);
                    }
                    if (!accessible) {
                        throw new IllegalAccessException("Method " + method + " has the wrong access level");
                    }
                    mthd.invoke((Object)this, out);
                }
                catch (NoSuchMethodException e) {
                    this.logger.warn((Object)("could't locate method: " + method));
                }
                catch (InvocationTargetException e) {
                    this.logger.error((Object)e.toString());
                }
                catch (IllegalAccessException e) {
                    this.logger.warn((Object)e.toString());
                }
                catch (IllegalArgumentException e) {
                    this.logger.error((Object)e.toString());
                }
            } else {
                this.logger.error((Object)"No method supplied.");
            }
        }
        catch (SecurityException e) {
            this.logger.warn((Object)e.toString());
        }
        catch (IOException e) {
            this.logger.error((Object)e.toString());
        }
    }

    public Log getLogger() {
        return this.logger;
    }

    private void setResponseHeaders(String mimeType, String attachmentName) {
        HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
        if (response == null) {
            return;
        }
        response.setHeader("Content-Type", mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        response.setHeader("Cache-Control", "max-age=0, no-store");
    }
}

