/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;
import net.stroffek.optimizer.algorithms.util.ArrayHeap;
import net.stroffek.optimizer.algorithms.util.ReachedNodeInfo;

public class DijkstraSolver
extends TSMPSolver {
    boolean stopped = false;
    Random rnd = new Random();
    ArrayHeap reachedPaths = null;
    HashMap visitedNodes = new HashMap();
    ReachedNodeInfo currentNodeInfo = null;
    ReachedNodeInfo bestNodeInfo = null;
    long nodesClosed = 0L;
    long nodesCreated = 0L;
    double[] estimates = null;

    @Override
    public synchronized int[] getBestSolution() {
        if (this.bestNodeInfo != null) {
            ReachedNodeInfo info = this.bestNodeInfo;
            this.bestSolution = new int[this.bestNodeInfo.pathLength];
            for (int i = 0; i < this.bestSolution.length; ++i) {
                this.bestSolution[i] = info.currentPoint;
                info = info.previous;
            }
        }
        return this.bestSolution;
    }

    @Override
    public synchronized int[] getCurrentSolution() {
        if (this.currentNodeInfo != null) {
            ReachedNodeInfo info = this.currentNodeInfo;
            this.currentSolution = new int[this.currentNodeInfo.pathLength];
            for (int i = 0; i < this.currentSolution.length; ++i) {
                this.currentSolution[i] = info.currentPoint;
                info = info.previous;
            }
        }
        return this.currentSolution;
    }

    @Override
    public synchronized boolean runSolverIteration() {
        ReachedNodeInfo info;
        int i;
        if (this.reachedPaths == null) {
            this.calculateEstimates();
            this.reachedPaths = new ArrayHeap();
            for (i = 0; i < this.points.length; ++i) {
                info = new ReachedNodeInfo();
                info.cost = 0.0;
                info.pathLength = 1;
                info.totalEstimates = this.estimates[1];
                info.currentPoint = i;
                info.visited = new boolean[this.points.length];
                for (int j = 0; j < this.points.length; ++j) {
                    info.visited[j] = false;
                }
                info.visited[i] = true;
                this.reachedPaths.insert(info);
                ++this.nodesCreated;
            }
        }
        this.reachedPaths.consistencyCheck();
        info = this.reachedPaths.removeMin();
        info.arrayHeapIndex = -1;
        this.currentNodeInfo = info;
        this.currentCost = this.currentNodeInfo.cost;
        if (this.bestNodeInfo == null || this.currentNodeInfo.pathLength > this.bestNodeInfo.pathLength) {
            this.bestNodeInfo = this.currentNodeInfo;
            this.bestCost = this.currentCost;
        }
        if (info == null) {
            return true;
        }
        ++this.nodesClosed;
        if (info.pathLength == this.points.length) {
            this.bestCost = info.cost;
            this.bestSolution = new int[this.points.length];
            for (i = 0; i < this.points.length; ++i) {
                this.bestSolution[i] = info.currentPoint;
                info = info.previous;
            }
            this.currentSolution = this.bestSolution;
            this.currentCost = this.bestCost;
            this.bestNodeInfo = null;
            this.currentNodeInfo = null;
            return true;
        }
        ReachedNodeInfo tmpInfo = new ReachedNodeInfo();
        tmpInfo.visited = Arrays.copyOf(info.visited, info.visited.length);
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            if (info.visited[i2]) continue;
            double newCost = info.cost + this.pointDistance(this.points[info.currentPoint], this.points[i2]);
            tmpInfo.visited[i2] = true;
            tmpInfo.currentPoint = i2;
            ReachedNodeInfo newInfo = (ReachedNodeInfo)this.visitedNodes.get(tmpInfo);
            if (newInfo != null && newInfo.cost > newCost) {
                newInfo.cost = newCost;
                newInfo.totalEstimates = newCost + this.estimates[newInfo.pathLength];
                newInfo.currentPoint = i2;
                newInfo.previous = info;
                if (newInfo.arrayHeapIndex >= 0) {
                    this.reachedPaths.propagateUp(newInfo.arrayHeapIndex);
                } else {
                    this.reachedPaths.insert(newInfo);
                }
            } else if (newInfo == null) {
                newInfo = new ReachedNodeInfo();
                newInfo.cost = newCost;
                newInfo.pathLength = info.pathLength + 1;
                newInfo.totalEstimates = newCost + this.estimates[newInfo.pathLength];
                newInfo.visited = Arrays.copyOf(tmpInfo.visited, tmpInfo.visited.length);
                newInfo.currentPoint = i2;
                newInfo.previous = info;
                this.reachedPaths.insert(newInfo);
                this.visitedNodes.put(newInfo, newInfo);
                ++this.nodesCreated;
            }
            tmpInfo.visited[i2] = false;
        }
        return false;
    }

    protected synchronized void calculateEstimates() {
        this.estimates = new double[this.points.length + 1];
        this.estimates[this.estimates.length - 1] = 0.0;
        for (int i = 0; i < this.estimates.length; ++i) {
            this.estimates[i] = 0.0;
        }
    }

    @Override
    public Object getParameterValue(int index) {
        switch (index) {
            case 0: {
                return Long.toString(this.nodesClosed);
            }
            case 1: {
                return Long.toString(this.nodesCreated);
            }
        }
        return null;
    }

    @Override
    public String getParameterDescription(int index) {
        switch (index) {
            case 0: {
                return "Nodes Closed";
            }
            case 1: {
                return "Nodes Created";
            }
        }
        return null;
    }
}

