/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.stroffek.optimizer.algorithms.examples.AStarLikeSolver;
import net.stroffek.optimizer.algorithms.examples.AStarSolver;
import net.stroffek.optimizer.algorithms.examples.DijkstraSolver;
import net.stroffek.optimizer.algorithms.examples.DrawingArea;
import net.stroffek.optimizer.algorithms.examples.DynamicSimulatedAnnealingSolver;
import net.stroffek.optimizer.algorithms.examples.HillClimbingSolver;
import net.stroffek.optimizer.algorithms.examples.IterativeImprovementSolver;
import net.stroffek.optimizer.algorithms.examples.NearestNeighborSolver;
import net.stroffek.optimizer.algorithms.examples.RandomSolver;
import net.stroffek.optimizer.algorithms.examples.SimulatedAnnealingSolver;
import net.stroffek.optimizer.algorithms.examples.SimulatedAnnealingV2Solver;
import net.stroffek.optimizer.algorithms.examples.SolverThread;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;
import net.stroffek.optimizer.algorithms.examples.UpdateViewThread;

public class MainFrame
extends JFrame {
    private JComboBox algorithmJComboBox;
    private JLabel algorithmJLabel;
    JTextField bestCostJTextField;
    private ButtonGroup buttonGroup1;
    private JButton clearJButton;
    private JSpinner countJSpinner;
    JTextField currentCostJTextField;
    public DrawingArea drawingArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    JLabel param1JLabel;
    JTextField param1JTextField;
    JLabel param2JLabel;
    JTextField param2JTextField;
    private JButton runJButton;
    public JRadioButton showBestJRadioButton;
    public JLabel statusJLabel;
    public JButton stopJButton;
    private JButton testJButton;
    SolverThread solverThread = null;
    UpdateViewThread updateViewThread = null;

    public MainFrame() {
        this.initComponents();
        this.updateViewThread = new UpdateViewThread();
        this.updateViewThread.setMainFrame(this);
        this.updateViewThread.stopAfterUpdate();
        this.updateViewThread.setSolver(null);
        this.updateViewThread.setShowBest(true);
        this.updateViewThread.start();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.drawingArea = new DrawingArea();
        this.statusJLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.runJButton = new JButton();
        this.stopJButton = new JButton();
        this.clearJButton = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.showBestJRadioButton = new JRadioButton();
        this.testJButton = new JButton();
        this.countJSpinner = new JSpinner();
        this.algorithmJComboBox = new JComboBox();
        this.algorithmJLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.bestCostJTextField = new JTextField();
        this.currentCostJTextField = new JTextField();
        this.param1JLabel = new JLabel();
        this.param1JTextField = new JTextField();
        this.param2JLabel = new JLabel();
        this.param2JTextField = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("PGCon 2007 Demo - Travelling Salesman Problem");
        this.drawingArea.setBackground(new Color(255, 255, 255));
        this.drawingArea.setBorder(BorderFactory.createTitledBorder("The best solution"));
        this.drawingArea.setName("drawingArea");
        this.countJSpinner.setValue(new Integer(10));
        this.drawingArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.drawingArea_mouseClicked(evt);
            }
        });
        GroupLayout drawingAreaLayout = new GroupLayout(this.drawingArea);
        this.drawingArea.setLayout(drawingAreaLayout);
        drawingAreaLayout.setHorizontalGroup(drawingAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 598, Short.MAX_VALUE));
        drawingAreaLayout.setVerticalGroup(drawingAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 576, Short.MAX_VALUE));
        this.drawingArea.getAccessibleContext().setAccessibleName("Drawing Area");
        this.statusJLabel.setText("Stopped.");
        this.statusJLabel.setName("statusJLabel");
        this.jPanel1.setMaximumSize(new Dimension(150, Short.MAX_VALUE));
        this.runJButton.setText("Run");
        this.runJButton.setName("runJButton");
        this.runJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.runJButton_actionPerformed(evt);
            }
        });
        this.stopJButton.setText("Stop");
        this.stopJButton.setName("runJButton");
        this.stopJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.stopJButton_actionPerformed(evt);
            }
        });
        this.clearJButton.setText("Clear");
        this.clearJButton.setName("clearJButton");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Show current solution");
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.showCurrentJRadioButton_actionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.showBestJRadioButton);
        this.showBestJRadioButton.setSelected(true);
        this.showBestJRadioButton.setText("Show best solution");
        this.showBestJRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showBestJRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.showBestJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.showBestJRadioButton_actionPerformed(evt);
            }
        });
        this.testJButton.setText("Generate Points");
        this.testJButton.setMaximumSize(new Dimension(80, 29));
        this.testJButton.setMinimumSize(new Dimension(80, 29));
        this.testJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.testJButtonAction(evt);
            }
        });
        this.countJSpinner.setToolTipText("The number of randompointsto generate");
        this.algorithmJComboBox.setMaximumRowCount(10);
        this.algorithmJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Random Path", "Simulated Annealing", "Dynamic Simulated Annealing", "Simulated Annealing V2", "Nearest Neighbor", "Hill Climbing", "Iterative Improvement", "Dijkstra's Algorithm", "A*", "Non-Optimal A* Like"}));
        this.algorithmJComboBox.setName("algorithmJComboBox");
        this.algorithmJLabel.setLabelFor(this.algorithmJComboBox);
        this.algorithmJLabel.setText("Select Algorithm:");
        this.algorithmJLabel.setName("algorithmJLabel");
        this.jLabel1.setText("Best Solution Cost:");
        this.jLabel2.setText("Current Solution Cost:");
        this.bestCostJTextField.setEditable(false);
        this.bestCostJTextField.setText("0");
        this.currentCostJTextField.setEditable(false);
        this.currentCostJTextField.setText("0");
        this.param1JLabel.setText("Parameter 1:");
        this.param1JLabel.setEnabled(false);
        this.param1JTextField.setEditable(false);
        this.param2JLabel.setText("Parameter 2:");
        this.param2JLabel.setEnabled(false);
        this.param2JTextField.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countJSpinner, GroupLayout.Alignment.TRAILING, -1, 207, Short.MAX_VALUE).addComponent(this.algorithmJLabel).addComponent(this.algorithmJComboBox, 0, 207, Short.MAX_VALUE).addComponent(this.clearJButton, -1, 207, Short.MAX_VALUE).addComponent(this.showBestJRadioButton).addComponent(this.jRadioButton1, -1, 207, Short.MAX_VALUE).addComponent(this.runJButton, -1, 207, Short.MAX_VALUE).addComponent(this.stopJButton, GroupLayout.Alignment.TRAILING, -1, 207, Short.MAX_VALUE).addComponent(this.testJButton, -1, 207, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.currentCostJTextField, -1, 207, Short.MAX_VALUE).addComponent(this.bestCostJTextField, -1, 207, Short.MAX_VALUE).addComponent(this.param1JLabel).addComponent(this.param2JLabel).addComponent(this.param1JTextField, -1, 207, Short.MAX_VALUE).addComponent(this.param2JTextField, -1, 207, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.algorithmJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.algorithmJComboBox, -2, -1, -2).addGap(22, 22, 22).addComponent(this.countJSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testJButton, -2, -1, -2).addGap(40, 40, 40).addComponent(this.runJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearJButton).addGap(15, 15, 15).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showBestJRadioButton).addGap(18, 18, 18).addComponent(this.param1JLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.param1JTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.param2JLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.param2JTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 102, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentCostJTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bestCostJTextField, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusJLabel, -1, 857, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawingArea, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drawingArea, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusJLabel)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 879) / 2, (screenSize.height - 662) / 2, 879, 662);
    }

    private void showBestJRadioButton_actionPerformed(ActionEvent evt) {
        Border border;
        if (this.solverThread != null) {
            this.updateViewThread.setShowBest(true);
        }
        if ((border = this.drawingArea.getBorder()) instanceof TitledBorder) {
            ((TitledBorder)border).setTitle("The best solution");
            this.drawingArea.repaint();
        }
    }

    private void showCurrentJRadioButton_actionPerformed(ActionEvent evt) {
        Border border;
        if (this.solverThread != null) {
            this.updateViewThread.setShowBest(false);
        }
        if ((border = this.drawingArea.getBorder()) instanceof TitledBorder) {
            ((TitledBorder)border).setTitle("The current solution");
            this.drawingArea.repaint();
        }
    }

    private void stopJButton_actionPerformed(ActionEvent evt) {
        if (this.solverThread != null) {
            if (this.solverThread.isAlive()) {
                this.updateViewThread.setSolver(null);
                this.solverThread.cancel();
                try {
                    this.solverThread.join();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.stopJButton.setText("Continue");
                this.stopJButton.setEnabled(true);
                this.statusJLabel.setText("Paused.");
                this.updateViewThread.stopAfterUpdate();
            } else {
                this.updateViewThread.resumeUpdate();
                SolverThread newSolverThread = new SolverThread();
                newSolverThread.setSolver(this.solverThread.getSolver());
                newSolverThread.setMainFrame(this.solverThread.getMainFrame());
                this.solverThread = newSolverThread;
                this.solverThread.start();
                this.stopJButton.setText("Stop");
            }
        }
    }

    private void runJButton_actionPerformed(ActionEvent evt) {
        if (this.solverThread != null) {
            this.solverThread.cancel();
            try {
                this.solverThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.solverThread = new SolverThread();
        this.solverThread.setMainFrame(this);
        TSMPSolver solver = null;
        switch (this.algorithmJComboBox.getSelectedIndex()) {
            case 0: {
                solver = new RandomSolver();
                break;
            }
            case 1: {
                solver = new SimulatedAnnealingSolver();
                break;
            }
            case 2: {
                solver = new DynamicSimulatedAnnealingSolver();
                break;
            }
            case 3: {
                solver = new SimulatedAnnealingV2Solver();
                break;
            }
            case 4: {
                solver = new NearestNeighborSolver();
                break;
            }
            case 5: {
                solver = new HillClimbingSolver();
                break;
            }
            case 6: {
                solver = new IterativeImprovementSolver();
                break;
            }
            case 7: {
                solver = new DijkstraSolver();
                break;
            }
            case 8: {
                solver = new AStarSolver();
                break;
            }
            case 9: {
                solver = new AStarLikeSolver();
                break;
            }
            default: {
                return;
            }
        }
        solver.setPoints(this.drawingArea.getPoints());
        this.solverThread.setSolver(solver);
        this.updateViewThread.resumeUpdate();
        this.updateViewThread.setSolver(solver);
        this.solverThread.start();
        this.stopJButton.setText("Stop");
    }

    private void drawingArea_mouseClicked(MouseEvent evt) {
        this.drawingArea.addPoint(evt.getLocationOnScreen().x - this.drawingArea.getLocationOnScreen().x, evt.getLocationOnScreen().y - this.drawingArea.getLocationOnScreen().y);
        this.drawingArea.repaint();
    }

    private void testJButtonAction(ActionEvent evt) {
        this.drawingArea.generatePoints((Integer)this.countJSpinner.getValue());
        this.drawingArea.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

