/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.util.Random;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;

public class SimulatedAnnealingSolver
extends TSMPSolver {
    boolean stopped = false;
    int[] oldSolution = null;
    double oldCost = Double.MAX_VALUE;
    Random rnd = new Random();
    double beta = 1.0;

    private void generateRandomSolution() {
        int i;
        int[] solution = new int[this.points.length];
        boolean[] used = new boolean[this.points.length];
        for (i = 0; i < this.points.length; ++i) {
            used[i] = false;
        }
        block1: for (i = 0; i < this.points.length; ++i) {
            int index = this.rnd.nextInt(this.points.length - i) + 1;
            for (int j = 0; j < this.points.length; ++j) {
                if (!used[j]) {
                    --index;
                }
                if (index != 0) continue;
                solution[i] = j;
                used[j] = true;
                continue block1;
            }
        }
        this.currentSolution = solution;
        this.currentCost = this.calculateCost(this.currentSolution);
    }

    protected synchronized void generateRandomChange() {
        int i;
        this.oldSolution = this.currentSolution;
        this.oldCost = this.currentCost;
        this.currentSolution = new int[this.oldSolution.length];
        for (i = 0; i < this.oldSolution.length; ++i) {
            this.currentSolution[i] = this.oldSolution[i];
        }
        i = this.rnd.nextInt(this.currentSolution.length);
        int j = this.rnd.nextInt(this.currentSolution.length - 1);
        if (j >= i) {
            ++j;
        }
        int tmp = this.currentSolution[i];
        this.currentSolution[i] = this.currentSolution[j];
        this.currentSolution[j] = tmp;
        this.currentCost = this.calculateCost(this.currentSolution);
    }

    @Override
    public synchronized boolean runSolverIteration() {
        if (this.currentSolution == null) {
            this.generateRandomSolution();
            this.bestSolution = this.currentSolution;
        } else {
            this.generateRandomChange();
            if (this.currentCost < this.bestCost) {
                this.bestSolution = this.currentSolution;
                this.bestCost = this.currentCost;
            }
            double change = this.currentCost - this.oldCost;
            double prop = 1.0 / (1.0 + Math.exp(this.beta * change));
            if (this.rnd.nextDouble() > prop) {
                this.currentSolution = this.oldSolution;
                this.currentCost = this.oldCost;
            }
            this.updateBeta(change);
        }
        return false;
    }

    protected void updateBeta(double currentChange) {
        this.beta = 1.0;
    }

    @Override
    public Object getParameterValue(int index) {
        switch (index) {
            case 0: {
                return new Double(this.beta);
            }
        }
        return null;
    }

    @Override
    public String getParameterDescription(int index) {
        switch (index) {
            case 0: {
                return "Beta";
            }
        }
        return null;
    }
}

