/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.awt.Point;

public abstract class TSMPSolver {
    Point[] points = null;
    int[] bestSolution = null;
    double bestCost = Double.MAX_VALUE;
    int[] currentSolution = null;
    double currentCost = Double.MAX_VALUE;

    public abstract boolean runSolverIteration();

    public synchronized Point[] getPoints() {
        return this.points;
    }

    public synchronized void setPoints(Point[] points) {
        this.points = points;
    }

    public synchronized int[] getBestSolution() {
        return this.bestSolution;
    }

    public synchronized int[] getCurrentSolution() {
        return this.currentSolution;
    }

    protected synchronized double calculateCost(int[] solution) {
        double cost = 0.0;
        Point[] points = this.getPoints();
        for (int i = 1; i < solution.length; ++i) {
            cost += this.pointDistance(points[solution[i - 1]], points[solution[i]]);
        }
        return cost;
    }

    public synchronized double getBestCost() {
        return this.bestCost;
    }

    public synchronized double getCurrentCost() {
        return this.currentCost;
    }

    public Object getParameterValue(int index) {
        return null;
    }

    public String getParameterDescription(int index) {
        return null;
    }

    protected double pointDistance(Point a, Point b) {
        return Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
    }
}

