/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import net.stroffek.optimizer.algorithms.examples.DrawingArea;
import net.stroffek.optimizer.algorithms.examples.MainFrame;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;

public class UpdateViewThread
extends Thread {
    protected MainFrame mainFrame = null;
    protected TSMPSolver solver = null;
    protected boolean showBest = true;
    protected boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                UpdateViewThread.sleep(100L);
            }
            catch (InterruptedException ex) {
                break;
            }
            UpdateViewThread updateViewThread = this;
            synchronized (updateViewThread) {
                if (this.solver != null && this.mainFrame != null) {
                    DrawingArea drawingArea = this.mainFrame.drawingArea;
                    synchronized (drawingArea) {
                        this.mainFrame.drawingArea.setPoints(this.solver.getPoints());
                        if (this.showBest) {
                            this.mainFrame.drawingArea.setPath(this.solver.getBestSolution());
                        } else {
                            this.mainFrame.drawingArea.setPath(this.solver.getCurrentSolution());
                        }
                        this.mainFrame.drawingArea.repaint();
                    }
                    this.mainFrame.bestCostJTextField.setText(Double.toString(this.solver.getBestCost()));
                    this.mainFrame.currentCostJTextField.setText(Double.toString(this.solver.getCurrentCost()));
                    int paramNo = 0;
                    String desc = this.solver.getParameterDescription(paramNo);
                    if (desc != null) {
                        this.mainFrame.param1JLabel.setText(desc + ":");
                        this.mainFrame.param1JLabel.setEnabled(true);
                        this.mainFrame.param1JTextField.setText(this.solver.getParameterValue(paramNo).toString());
                    } else {
                        this.mainFrame.param1JLabel.setText("Parameter " + paramNo + ":");
                        this.mainFrame.param1JLabel.setEnabled(false);
                        this.mainFrame.param1JTextField.setText("");
                    }
                    paramNo = 1;
                    desc = this.solver.getParameterDescription(paramNo);
                    if (desc != null) {
                        this.mainFrame.param2JLabel.setText(desc + ":");
                        this.mainFrame.param2JLabel.setEnabled(true);
                        this.mainFrame.param2JTextField.setText(this.solver.getParameterValue(paramNo).toString());
                    } else {
                        this.mainFrame.param2JLabel.setText("Parameter " + paramNo + ":");
                        this.mainFrame.param2JLabel.setEnabled(false);
                        this.mainFrame.param2JTextField.setText("");
                    }
                    if (this.stopped) {
                        this.solver = null;
                    }
                }
            }
        }
    }

    public synchronized MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public synchronized void setMainFrame(MainFrame aMainFrame) {
        this.mainFrame = aMainFrame;
    }

    public synchronized TSMPSolver getSolver() {
        return this.solver;
    }

    public synchronized void setSolver(TSMPSolver solver) {
        this.solver = solver;
    }

    boolean getShowBest() {
        return this.showBest;
    }

    public void setShowBest(boolean aShowBest) {
        this.showBest = aShowBest;
    }

    public void stopAfterUpdate() {
        this.stopped = true;
    }

    public void resumeUpdate() {
        this.stopped = false;
    }
}

