/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Random;
import javax.swing.JPanel;

public class DrawingArea
extends JPanel {
    Random rnd = new Random();
    private int[] path = null;
    private Point[] points = new Point[0];

    @Override
    public synchronized void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        g.setColor(Color.RED);
        for (i = 0; i < this.points.length; ++i) {
            g.fillOval(this.points[i].x - 3, this.points[i].y - 3, 6, 6);
        }
        g.setColor(Color.BLUE);
        if (this.path != null) {
            for (i = 1; i < this.path.length; ++i) {
                if (this.path[i - 1] < 0 || this.path[i] < 0) continue;
                g.drawLine(this.points[this.path[i - 1]].x, this.points[this.path[i - 1]].y, this.points[this.path[i]].x, this.points[this.path[i]].y);
            }
        }
    }

    public synchronized void generatePoints(int count) {
        this.points = new Point[count];
        for (int i = 0; i < count; ++i) {
            this.points[i] = new Point();
            this.points[i].x = this.rnd.nextInt(this.getWidth() - 20) + 10;
            this.points[i].y = this.rnd.nextInt(this.getHeight() - 25) + 15;
        }
        this.path = null;
    }

    public synchronized int[] getPath() {
        return this.path;
    }

    public synchronized void setPath(int[] path) {
        this.path = path;
    }

    public synchronized void addPoint(int x, int y) {
        Point[] newPoints = new Point[this.points.length + 1];
        for (int i = 0; i < this.points.length; ++i) {
            newPoints[i] = this.points[i];
        }
        newPoints[this.points.length] = new Point();
        newPoints[this.points.length].x = x;
        newPoints[this.points.length].y = y;
        this.points = newPoints;
        this.path = null;
    }

    public synchronized void addPoints(Point[] points) {
        int i;
        Point[] newPoints = new Point[this.points.length + points.length];
        for (i = 0; i < this.points.length; ++i) {
            newPoints[i] = this.points[i];
        }
        for (i = 0; i < points.length; ++i) {
            newPoints[this.points.length + i] = points[i];
        }
        this.points = newPoints;
        this.path = null;
    }

    public synchronized Point[] getPoints() {
        return this.points;
    }

    public synchronized void setPoints(Point[] points) {
        this.points = points;
    }
}

