/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import net.stroffek.optimizer.algorithms.examples.SimulatedAnnealingSolver;

public class DynamicSimulatedAnnealingSolver
extends SimulatedAnnealingSolver {
    int N = 50;
    double nAvgChange = 0.0;
    int stability = 10;
    double alfa = 10.0;

    @Override
    protected void updateBeta(double currentChange) {
        double avgStabProp = Math.pow(10.0, -this.stability);
        this.nAvgChange = ((double)(this.N - 1) * this.nAvgChange + Math.abs(currentChange)) / (double)this.N;
        this.beta = this.alfa * Math.log(1.0 / avgStabProp - 1.0) / this.nAvgChange;
    }

    @Override
    public Object getParameterValue(int index) {
        switch (index) {
            case 0: {
                return new Double(this.beta);
            }
            case 1: {
                return new Double(this.nAvgChange);
            }
        }
        return null;
    }

    @Override
    public String getParameterDescription(int index) {
        switch (index) {
            case 0: {
                return "Beta";
            }
            case 1: {
                return "Absolut Average Change";
            }
        }
        return null;
    }
}

