/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.awt.Point;
import java.util.Random;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;

public class HillClimbingSolver
extends TSMPSolver {
    boolean stopped = false;
    int[] bestSolution = null;
    int[] currentSolution = null;
    int[] startSolution = null;
    double startCost = Double.MAX_VALUE;
    Point[] points;
    Random rnd = new Random();
    int first = 0;
    int second = 1;

    @Override
    public synchronized void setPoints(Point[] points) {
        this.points = points;
    }

    @Override
    public synchronized int[] getBestSolution() {
        return this.bestSolution;
    }

    @Override
    public synchronized int[] getCurrentSolution() {
        return this.currentSolution;
    }

    private boolean getNextNeighbor() {
        if (this.first == this.startSolution.length - 2 && this.second == this.startSolution.length - 1) {
            return false;
        }
        this.currentSolution = new int[this.startSolution.length];
        for (int i = 0; i < this.startSolution.length; ++i) {
            this.currentSolution[i] = this.startSolution[i];
        }
        if (this.second == this.startSolution.length - 1) {
            ++this.first;
            this.second = this.first + 1;
        } else {
            ++this.second;
        }
        this.currentSolution[this.first] = this.startSolution[this.second];
        this.currentSolution[this.second] = this.startSolution[this.first];
        this.currentCost = this.calculateCost(this.currentSolution);
        return true;
    }

    private void generateRandomSolution() {
        int i;
        int[] solution = new int[this.points.length];
        boolean[] used = new boolean[this.points.length];
        for (i = 0; i < this.points.length; ++i) {
            used[i] = false;
        }
        block1: for (i = 0; i < this.points.length; ++i) {
            int index = this.rnd.nextInt(this.points.length - i) + 1;
            for (int j = 0; j < this.points.length; ++j) {
                if (!used[j]) {
                    --index;
                }
                if (index != 0) continue;
                solution[i] = j;
                used[j] = true;
                continue block1;
            }
        }
        this.currentSolution = solution;
        this.currentCost = this.calculateCost(this.currentSolution);
    }

    @Override
    public synchronized boolean runSolverIteration() {
        if (this.bestSolution == null) {
            this.generateRandomSolution();
            this.bestSolution = new int[this.points.length];
            this.startSolution = new int[this.points.length];
            for (int i = 0; i < this.currentSolution.length; ++i) {
                this.bestSolution[i] = this.currentSolution[i];
                this.startSolution[i] = this.currentSolution[i];
            }
            this.bestCost = this.currentCost;
            this.startCost = this.currentCost;
        } else {
            if (!this.getNextNeighbor()) {
                if (this.bestCost < this.startCost) {
                    this.startSolution = this.bestSolution;
                    this.startCost = this.bestCost;
                    this.first = 0;
                    this.second = 1;
                } else {
                    return true;
                }
            }
            if (this.currentCost < this.bestCost) {
                this.bestSolution = this.currentSolution;
                this.bestCost = this.currentCost;
            }
        }
        return false;
    }

    @Override
    public synchronized Point[] getPoints() {
        return this.points;
    }
}

