/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.awt.Point;
import java.util.Random;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;

public class IterativeImprovementSolver
extends TSMPSolver {
    boolean newRun = false;
    int changeCounter = 0;
    int neighbors;
    boolean stopped = false;
    int[] bestSolution = null;
    int[] currentSolution = null;
    int[] oldSolution = null;
    double oldCost = Double.MAX_VALUE;
    Point[] points;
    Random rnd = new Random();

    @Override
    public synchronized void setPoints(Point[] points) {
        this.points = points;
        for (int i = points.length - 1; i > 0; --i) {
            this.neighbors += i;
        }
    }

    @Override
    public synchronized int[] getBestSolution() {
        return this.bestSolution;
    }

    @Override
    public synchronized int[] getCurrentSolution() {
        return this.currentSolution;
    }

    private void generateRandomSolution() {
        int i;
        int[] solution = new int[this.points.length];
        boolean[] used = new boolean[this.points.length];
        for (i = 0; i < this.points.length; ++i) {
            used[i] = false;
        }
        block1: for (i = 0; i < this.points.length; ++i) {
            int index = this.rnd.nextInt(this.points.length - i) + 1;
            for (int j = 0; j < this.points.length; ++j) {
                if (!used[j]) {
                    --index;
                }
                if (index != 0) continue;
                solution[i] = j;
                used[j] = true;
                continue block1;
            }
        }
        this.currentSolution = solution;
        this.currentCost = this.calculateCost(this.currentSolution);
    }

    private synchronized void generateRandomChange() {
        int i;
        this.oldSolution = this.currentSolution;
        this.oldCost = this.currentCost;
        this.currentSolution = new int[this.oldSolution.length];
        for (i = 0; i < this.oldSolution.length; ++i) {
            this.currentSolution[i] = this.oldSolution[i];
        }
        i = this.rnd.nextInt(this.currentSolution.length);
        int j = this.rnd.nextInt(this.currentSolution.length - 1);
        if (j >= i) {
            ++j;
        }
        int tmp = this.currentSolution[i];
        this.currentSolution[i] = this.currentSolution[j];
        this.currentSolution[j] = tmp;
        this.currentCost = this.calculateCost(this.currentSolution);
    }

    @Override
    public synchronized boolean runSolverIteration() {
        if (this.currentSolution == null) {
            this.generateRandomSolution();
            this.bestSolution = this.currentSolution;
            this.bestCost = this.currentCost;
            return false;
        }
        if (this.newRun) {
            this.generateRandomSolution();
            if (this.currentCost < this.bestCost) {
                this.bestSolution = this.currentSolution;
                this.bestCost = this.currentCost;
            }
            this.newRun = false;
            return false;
        }
        this.generateRandomChange();
        if (this.currentCost > this.oldCost) {
            this.currentSolution = this.oldSolution;
            this.currentCost = this.oldCost;
            ++this.changeCounter;
        } else {
            this.changeCounter = 0;
        }
        if (this.currentCost < this.bestCost) {
            this.bestSolution = this.currentSolution;
            this.bestCost = this.currentCost;
        }
        if ((long)this.changeCounter > Math.round(Math.log(this.points.length)) * 5L) {
            System.out.println("New run, counter: " + this.changeCounter);
            this.changeCounter = 0;
            this.newRun = true;
            return false;
        }
        return false;
    }

    @Override
    public synchronized Point[] getPoints() {
        return this.points;
    }
}

