/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.examples;

import java.util.Random;
import net.stroffek.optimizer.algorithms.examples.TSMPSolver;

public class NearestNeighborSolver
extends TSMPSolver {
    boolean stopped = false;
    int startIndex = -1;
    Random rnd = new Random();

    @Override
    public synchronized boolean runSolverIteration() {
        int[] solution = new int[this.points.length];
        boolean[] used = new boolean[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            used[i] = false;
        }
        if (this.startIndex >= this.points.length - 1) {
            this.startIndex = -1;
        }
        int last = ++this.startIndex;
        int index = -1;
        double nearestDistance = Double.MAX_VALUE;
        solution[0] = last;
        used[last] = true;
        for (int i = 1; i < this.points.length; ++i) {
            nearestDistance = Double.MAX_VALUE;
            for (int j = 0; j < this.points.length; ++j) {
                double distance;
                if (used[j] || !((distance = Math.sqrt((this.points[last].x - this.points[j].x) * (this.points[last].x - this.points[j].x) + (this.points[last].y - this.points[j].y) * (this.points[last].y - this.points[j].y))) < nearestDistance)) continue;
                index = j;
                nearestDistance = distance;
            }
            solution[i] = index;
            used[index] = true;
            last = index;
        }
        this.currentSolution = solution;
        this.currentCost = this.calculateCost(this.currentSolution);
        if (this.currentCost < this.bestCost) {
            this.bestSolution = this.currentSolution;
            this.bestCost = this.currentCost;
        }
        return this.startIndex == this.points.length - 1;
    }
}

