/*
 * Decompiled with CFR 0.152.
 */
package net.stroffek.optimizer.algorithms.util;

import net.stroffek.optimizer.algorithms.util.Heap;
import net.stroffek.optimizer.algorithms.util.ReachedNodeInfo;

public class ArrayHeap
extends Heap {
    int minArraySize = 0;
    int arraySize = 0;
    int elementCount = 0;
    ReachedNodeInfo[] array = null;

    public ArrayHeap() {
        this.arraySize = this.minArraySize = 16;
        this.elementCount = 0;
        this.array = new ReachedNodeInfo[this.arraySize];
    }

    public ArrayHeap(int aMinArraySize) {
        this.arraySize = this.minArraySize = aMinArraySize;
        this.elementCount = 0;
        this.array = new ReachedNodeInfo[this.arraySize];
    }

    @Override
    public ReachedNodeInfo getMinObject() {
        if (this.elementCount > 0) {
            return this.array[0];
        }
        return null;
    }

    @Override
    public double getMinValue() {
        if (this.elementCount > 0) {
            return this.array[0].totalEstimates;
        }
        return Double.MIN_VALUE;
    }

    @Override
    public void insert(ReachedNodeInfo object) {
        object.arrayHeapIndex = this.elementCount;
        this.array[this.elementCount] = object;
        this.propagateUp(this.elementCount);
        ++this.elementCount;
        this.maintainArraySize();
    }

    @Override
    public ReachedNodeInfo removeMin() {
        if (this.elementCount < 1) {
            return null;
        }
        ReachedNodeInfo info = this.array[0];
        if (this.elementCount == 1) {
            --this.elementCount;
            this.array[0] = null;
        } else {
            --this.elementCount;
            this.array[0] = this.array[this.elementCount];
            this.propagateDown(0);
        }
        this.maintainArraySize();
        return info;
    }

    protected void propagateDown(int index) {
        int i = index;
        int j = 0;
        while (i < this.elementCount) {
            if (2 * i > this.elementCount || this.array[i].totalEstimates <= this.array[2 * i].totalEstimates) {
                if (2 * i + 1 > this.elementCount || this.array[i].totalEstimates <= this.array[2 * i + 1].totalEstimates) {
                    return;
                }
                j = 2 * i + 1;
            } else {
                j = 2 * i + 1 > this.elementCount || this.array[i].totalEstimates <= this.array[2 * i + 1].totalEstimates ? 2 * i : (this.array[2 * i].totalEstimates <= this.array[2 * i + 1].totalEstimates ? 2 * i : 2 * i + 1);
            }
            ReachedNodeInfo o = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = o;
            this.array[i].arrayHeapIndex = i;
            this.array[j].arrayHeapIndex = j;
            i = j;
        }
    }

    public void propagateUp(int index) {
        int i = index;
        int j = 0;
        while (i > 0) {
            j = i / 2;
            if (this.array[j].totalEstimates <= this.array[i].totalEstimates) {
                return;
            }
            ReachedNodeInfo o = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = o;
            this.array[i].arrayHeapIndex = i;
            this.array[j].arrayHeapIndex = j;
            i = j;
        }
    }

    protected void maintainArraySize() {
        int newSize = 0;
        if (this.arraySize > this.minArraySize && this.elementCount < this.arraySize / 3) {
            newSize = this.arraySize / 2;
        } else if (this.elementCount == this.arraySize) {
            newSize = this.arraySize * 2;
        } else {
            return;
        }
        ReachedNodeInfo[] newObjectArray = new ReachedNodeInfo[newSize];
        double[] newValueArray = new double[newSize];
        for (int i = 0; i < this.elementCount; ++i) {
            newObjectArray[i] = this.array[i];
        }
        this.arraySize = newSize;
        this.array = newObjectArray;
    }

    public void consistencyCheck() {
        for (int i = 1; i < this.elementCount; ++i) {
            int j = i / 2;
            if (!(this.array[j].totalEstimates > this.array[i].totalEstimates)) continue;
            System.err.println("Heap consistency check error!!!");
        }
    }
}

