;  completeusersproofGUI.ahk    After compiling, this file runs an AutoHotkey  
;                               script. The script first loads two   
;                               instances of the mmj2 program (with their
;                               GUIs) by executing mmj2FalseDeductionsG.bat
;                               and mmj2StepProverG.bat. It then opens a
;                               third GUI window which contains the buttons
;                               "Completeusersproof",
;                               "Completeusersproof smv",
;                               "Completeusersproof mv", "Stepprover", and
;                               "Exit/Quit". Pressing one of the first four
;                               buttons runs completeusersproof with first
;                               command line argument being, respectively,
;                               """", "runCompleteusersproofSmv",
;                               "runCompleteusersproofMv", and
;                               "runStepprover".


; *****************************************************************************
; *****************************************************************************
; BOOT INSTANCE OF mmj2 FOR WHICH fd.txt IS LOADED

Run, c:\mmj2\mmj2jar\mmj2FalseDeductionsG.bat
; Start the mmj2 instance which loads the fd.txt ff* false deductions as well
; as set.mm.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE PREVENTING THE "Save" WINDOW FROM POPPING UP FOR THE INSTANCE OF
; mmj2 FOR WHICH fd.txt IS LOADED

; This is the beginning of the subroutine which is run immediately after the
; FF mmj2 instance starts whose sole purpose is to prevent the "Save" window
; from becoming existent and active at any time during the execution of
; completeusersproof.
;
; This subroutine is identical to unifyFF.ahk except for shorter Sleep
; durations and two consecutive statments at the point after Enter is pressed
; in the "getYesNo" window. Normally pressing Enter will cause the existing
; file to be saved before the new file is opened. Usually, for the first
; mmj2 unification after mmj2 boots, pressing Enter causes the "Save" window
; to become existent and active. The two additional statements close that
; "Save" window. This subroutine is that first mmj2 unification after mmj2
; boots. It serves no purpose other than to prevent the "Save" window from
; becoming existent and active for any mmj2 unifications when
; completeusersproof is run.

Sleep, 40
; Provide a delay of at least 40 milliseconds after every statement to increase
; the probability of reliable performance of the script for a negligible cost.

WinWait, ProofAsstGUI - proofWorksheetFF.mmp,

Sleep, 40

IfWinNotActive, ProofAsstGUI - proofWorksheetFF.mmp, , WinActivate, ProofAsstGUI - proofWorksheetFF.mmp,

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheetFF.mmp,

Sleep, 40

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 40

WinWaitActive, Open,

Sleep, 40

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 40
 
WinWaitActive, ProofAsstGUI - proofWorksheetFF.mmp,

Sleep, 40

Send, {CTRLDOWN}up{CTRLUP}

Sleep, 40

WinWaitActive, Open,

Sleep, 40

Send, {ESCAPE}

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheetFF.mmp

Sleep, 40

Send, {ENTER}{BACKSPACE}{CTRLDOWN}p{CTRLUP}

Sleep, 40

WinWaitActive, getYesNo

Sleep, 40

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 40

WinWaitActive, Save,,.1
; Delay execution of the next statement until the "Save" window activates
; or(excl.) 100 milliseconds elapses.
;
; It is assumed that if the "Save" window shall become existent and activate
; that it shall do so within 100 milliseconds.
;
; It is assumed that the "Save" window may become existent and activate after
; the "Yes" button is pressed in the "getYesNo" window only with the first
; mmj2 unify command after mmj2 is loaded. Usually it will, but sometimes it
; may not.

Sleep, 40

IfWinActive, Save,,,, Send, {ENTER}
; If the "Save" window shall become existent and active it is assumed that it
; will be existent and active when this statement is executed. If it is
; existent and active the Enter button is pressed to save the file and close
; the "Save" window. If the "Save" window shall not become existent and active
; it shall not be active when the instant statement is executed and the next
; statement will be executed with no action taken by the instant statement.
;
; The observed behavior is that when "Yes" is chosen in the "getYesNo" window
; that the "Save" window will usually but not always become existent and active
; before the "Open" window becomes existent and active. If the "Save" window
; does become existent and active, this statement and the last statement deal
; with this by waiting until the "Save" window becomes existent and active and
; pressing the "Yes" button in the "Save" window to cause the "Save" window to
; become nonexistent. Afterwards, the "Open" window will become existent and
; active.
;
; A summary of the purpose of this statement and the last follows. The "Save"
; window sometimes becomes existent and active at this point. It is presumed to
; occur only for the first mmj2 unificiation after mmj2 has been loaded.
; Sometimes it does not occur even then. If it does, that window should be
; closed. The "Open" window will not become existent and activate until the
; "Save" window, if it becomes existent and active, closes. Execution
; stops if the "Save" window becomes existent and active. Note that the
; WinWaitActive, Open next statement never times out because no time-out
; value is specified. If the "Save" window becomes existent and active and
; is not closed, then the next statement will pause execution indefinitely
; because the "Open" window will never become existent and active.

Sleep, 40

WinWaitActive, Open

Sleep, 160

Send, {ESCAPE}

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheetFF.mmp

Sleep, 40


; *****************************************************************************
; *****************************************************************************
; BOOT INSTANCE OF mmj2 FOR WHICH fd.txt IS NOT LOADED

Run, c:\mmj2\mmj2jar\mmj2StepProverG.bat
; Boot the instance of mmj2 which loads only the set.mm theorems and does
; not load the fd.txt ff* false deductions.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE PREVENTING THE "Save" WINDOW FROM POPPING UP FOR THE INSTANCE OF
; mmj2 FOR WHICH fd.txt IS NOT LOADED

; This is the beginning of the subroutine which is run immediately after the
; non-FF mmj2 instance boots up whose sole purpose is to prevent the "Save"
; window from becoming existent and active at any time during the execution
; of completeusersproof.
;
; This subroutine is identical to the above subroutine for preventing the
; "Save" window from popping up for the instance of mmj2 for which both set.mm
; and fd.txt are loaded, except each instance of
; "ProofAsstGUI - proofWorksheetFF.mmp" is replaced with
; "ProofAsstGUI - proofWorksheet.mmp". This change is necessary because the
; Title of the window in which buttons are pressed or characters are
; are automatically typed is "ProofAsstGUI - proofWorksheet.mmp", not
; "ProofAsstGUI - proofWorksheetFF.mmp".

Sleep, 40

WinWait, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 40

IfWinNotActive, ProofAsstGUI - proofWorksheet.mmp, , WinActivate, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 40

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 40

WinWaitActive, Open,

Sleep, 40

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 40
 
WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 40

Send, {CTRLDOWN}up{CTRLUP}

Sleep, 40

WinWaitActive, Open,

Sleep, 40

Send, {ESCAPE}

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 40

Send, {ENTER}{BACKSPACE}{CTRLDOWN}p{CTRLUP}

Sleep, 40

WinWaitActive, getYesNo

Sleep, 40

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 40

WinWaitActive, Save,,.1

Sleep, 40

IfWinActive, Save,,,, Send, {ENTER}

Sleep, 40

WinWaitActive, Open

Sleep, 160

Send, {ESCAPE}

Sleep, 40

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 40


; *****************************************************************************
; *****************************************************************************
; CONSTRUCT AND SHOW THE completeusersproof GUI

Menu, Tray, Icon, c:\mmj2\mmj2jar\Document-margins.ico
; Set icon for GUI titlebar.

Sleep, 10

Gui, Font, s12, Arial
; Set font for all controls added below. Each of these controls is a
; button. The default color of the font is black.

Sleep, 10

Gui, Color, ControlColor, FFF0F5
; Specify the color of all controls added below (which are buttons) to
; the html color "LavenderBlush". This is the best match we can find to the
; color of the dropdown background of the mmj2 GUI.

Sleep, 10

Gui, Add, Button, x0 y0 h20 w200 gCompleteusersproof,Completeusersproof
; Add a button to the completeusersproof GUI. This button is to run
; completeusersproof with the first command line argument's value equal to
; the default value """". The User's Proof is processed using the unification
; theorem means.

Sleep, 10

Gui, Add, Button, x0 y20 h20 w200 gCompleteusersproof_smv,Completeusersproof smv
; Add the button to run completeusersproof with the first command line
; argument's value equal to "runCompleteusersproofsmv". The User's Proof is
; processed using the single metavariable deduction unification means.

Sleep, 10

Gui, Add, Button, x0 y40 h20 w200 gCompleteusersproof_mv,Completeusersproof mv
; Add the button to run completeusersproof with the first command line
; argument's value equal to "runCompleteusersproofmv". The User's Proof is
; processed using the metavariable deduction unification means.

Sleep, 10

Gui, Add, Button, x0 y60 h20 w200 gStepprover,Stepprover
; Add the button to run completeusersproof with the first command line
; argument's value equal to "runStepprover". The User's Proof is
; processed by running only the stepprover() function.

Sleep, 10

Gui, Add, Button, x0 y80 h20 w200 gClose,Exit/Quit
; When the User presses this button the completeusersproof GUI closes. Of
; course, the GUIs of the two mmj2 instances are not affected.

Sleep, 10

Gui, Show, w200 h100
; "gCompleteusersproof" means that when the button is pressed,
; the script after the "Completeusersproof" label is executed.
; "g" is an abbreviation for "goto". It goes to the specified label.

Sleep, 10

WinSetTitle,completeusersproofGUI,,
; This statement changes the Title of the window which includes
; "completeusersproofGUI" in its Title to "".

Sleep, 10

return


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE RUN WHEN THE "Completeusersproof" BUTTON IS PRESSED

Completeusersproof:
; The statements below this label "Completeusersproof" are executed
; when the button "Completeusersproof" is pressed. While the character string
; on the button matches the the goto label here, this matching is not necessary
; for .ahk scripts generally.

{
; The body of code after the goto label and associated with that label is
; enclosed in braces.

IfWinNotExist,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return
; If the User did open a file in any mmj2 GUI window, then this conditional
; will be false and the return statement will not be executed. If the User
; did not open a file in any mmj2 GUI window, this this conditional will be
; true and the program will return with no action caused by pressing the
; button. The program will continue waiting for the next button press.

Sleep, 10

IfWinNotExist,ProofAsstGUI - proofWorksheetFF.mmp,,,, return
; If the "GUI - proofWorksheetFF.mmp" window does not exist, then either the
; FF mmj2 has not been loaded or(excl.) it has been loaded and the User, in
; error, has opened a file other than proofWorksheetFF.mmp into the FF mmj2 GUI.
; In both cases the User has not opened the file containing the proof he
; wishes to complete in the non-FF mmj2 GUI.  Therefore, execution of
; completeusersproof ought not occur. The present instance of pressing the
; "Completeusersproof" button has no effect.
;
; The only case for which the User can execute an invalid action is if he opens
; proofWorksheet.mmp in the mmj2 instance loaded with fd.txt and opens
; proofWorksheetFF.mmp in the mmj2 instance not loaded with fd.txt. It is
; unlikely a User would do this. It is difficult to conceive of a motive a
; User would have for doing that.

Sleep, 10
  
WinActivate,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet
; Because the program has reached this statement, the FF mmj2 was loaded
; and the non-FF mmj2 was loaded and the User opened a file containing
; a proof in the non-FF mmj2. It is presumed the User has opened a file
; containing a valid mmj2 Proof Worksheet. This subroutine accepts this file
; and executes completeusersproof in response to the User pressing the
; "Completeusersproof" button.
;
; If the non-FF mmj2 window is already active, this statement will do nothing.
; If its not active, this statement will activate it.
;
; The two commas means that the second parameter is not specified. It
; specifies Text contained in a window to be opened. Text specification
; does not work for the mmj2 GUI. The third parameter is a string that
; the window to be activated must NOT include. We don't want any window to
; be activated whose Title includes the string "proofWorksheet". This excludes
; both the windows "ProofAsstGUI - proofWorksheet.mmp" and
; "ProofAsstGUI - proofWorksheetFF.mmp" from being activated. The window we
; wish to be activated has a Title which includes the string "ProofAsstGUI -"
; and excludes the string "proofWorksheet". It includes the string which is the
; label of the proof specified by the User for completion. That label is an
; unknown variable.
;
; The mmj2 GUI is designed so that the filename of the open file occurs in the
; mmj2 GUI Title after the string "ProofAsstGUI - ". The User ought not include
; the string "proofWorksheet" in the filename of the Proof Worksheet to which
; he wishes to apply completeusersproof.

Sleep, 10

WinWaitActive,ProofAsstGUI -,,3,ProofAsstGUI - proofWorksheet
; Delay execution of the next statement until the above window has become
; active, or, if it never becomes active, after 3 seconds has elapsed.

Sleep, 10

IfWinNotActive,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return
; If the program reached this point, the non-FF mmj2 GUI should contain an open
; User's Proof and should be active. If that is not the case then things are
; not the way they should be and the button press causing the execution of the
; present subroutine has no effect.

Sleep, 10

Send, {F10}{Down}{Down}{ENTER}
; Having reached this point in execution, the User did open a file containing
; a proof he wishes completed.
;
; Press the "Save As" button of the mmj2 GUI.

Sleep, 10

WinWaitActive, Save
; Wait for the "Save" window to come into existence and become active. Execute
; the next statement the moment this occurs.

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\proofWorksheet.txt{ENTER}
; Copy the Proof Worksheet opened by the User to
; c:\mmj2\mmj2jar\proofWorksheet.txt . {BACKSPACE} deletes the default file to
; save to from the filename bar of the "Save" window.
; "c:\mmj2\mmj2jar\proofWorksheet.txt" types the placeholder file to
; temporarily hold the User's Proof. {ENTER} presses the Save button.

Sleep, 10

WinWaitActive, getYesNoAnswer()
; After the User presses Enter in the last statement, this window comes into
; existence and becomes active. It asks the User to verify that he wishes to
; overwrite onto the file specified in the "Save" window. The instant
; statement delays execution of the next statement until the getYesNoAnswer()
; window becomes active.

Sleep, 10

Send, {ENTER}
; Press the "Yes" button of the getYesNoAnswer() window, indicating that the
; User wishes to overwrite the file c:\mmj2\mmj2jar\proofWorksheet.txt with the
; contents of the file opened by the User, which is the proof he wishes to be
; completed by completeusersproof.

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.txt
; Delay the execution of the next statement until the window with the Title
; specified in the instant statement becomes the Title of the existing window
; and that window becomes active.

Sleep, 10

Send, {CTRLDOWN}p{CTRLUP}
; This causes the "Open" window to come into existence and to become active.
; The motive is to open proofWorksheet.mmp so that the Title of the active
; window will become "ProofAsstGUI - proofWorksheet.mmp".

Sleep, 10

WinWaitActive, Open
; Delay the execution of the next statement until the "Open" window has come
; into existence and has become active.

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\myproofs\proofWorksheet.mmp{ENTER}
; Clear the file name bar using {BACKSPACE}, then type in the full path of
; proofWorksheet.mmp, which is the file to be opened. Press {ENTER} to open
; this file.

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp
; Delay execution of the next statement until the existing window becomes
; titled as specified in this statement and becomes active.

Sleep, 10

Run, c:\mmj2\mmj2jar\completeusersproof.bat
; At this point in the execution of completeusersproofGUI both mmj2 GUIs are
; ready for execution of completeusersproof. completeusersproof does not
; loop. It runs once. It will complete the proof(as much as possible) which the
; User specified by opening the file containing it. The completed proof will
; be saved in proofWorksheet.txt. It will also be saved in
; c:\mmj2\mmj2jar\myproofs\<theorem>, where <theorem> is the theorem label
; in the header of the Proof Worksheet. It will also appear in the non-FF mmj2
; GUI under the name proofWorksheet.mmp.
;
; completeusersproof.exe process the User's Proof using the unification theorem
; means.
;
; After the execution of completeusersproof has completed the
; completeusersproof GUI will remain open, waiting for the User to press one
; of its buttons again. The User may processes as many proofs as he wishes. The
; User closes the completeusersproof GUI by pressing the "Exit/Quit" button.

}
; This close curly brace is necessary to mark the end of the body of code after
; the "Completeusersproof" label.

Sleep, 10

return
; The code enclosed in curly braces after the "Completeusersproof" label is
; executed in response to the User's pressing of the "Completeusersproof"
; button. After saving the file which had been opened in the mmj2 GUI by the
; User it re-Titles the window back to "ProofAsstGUI - proofWorksheet.mmp". The
; instant return statement ends this instance of executing completeusersproof.
; The completeusersproof GUI remains open, ready to respond to the next button
; press by the User.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE RUN WHEN THE "Completeusersproof smv" BUTTON IS PRESSED

Completeusersproof_smv:
; Statements below this label "Completeusersproof_smv" are executed
; when the Completeusersproof_smv button is pressed.

{

IfWinNotExist,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

IfWinNotExist,ProofAsstGUI - proofWorksheetFF.mmp,,,, return

Sleep, 10
  
WinActivate,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet

Sleep, 10

WinWaitActive,ProofAsstGUI -,,3,ProofAsstGUI - proofWorksheet

Sleep, 10

IfWinNotActive,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

Send, {F10}{Down}{Down}{ENTER}

Sleep, 10

WinWaitActive, Save

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\proofWorksheet.txt{ENTER}

Sleep, 10

WinWaitActive, getYesNoAnswer()

Sleep, 10

Send, {ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.txt

Sleep, 10

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 10

WinWaitActive, Open

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\myproofs\proofWorksheet.mmp{ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 10

Run, c:\mmj2\mmj2jar\completeusersproofSmv.bat
; Execute this .bat file. The value of argv[1] for this .bat file is
; "runCompleteusersproofsmv". completeusersproof.exe is executed. The User's
; Proof is processed using the single metavariable deduction unification means.

}

Sleep, 10

return
; The code enclosed in curly braces after the "Completeusersproof_smv" label is
; executed in response to the User's press of the "Completeusersproof smv"
; button.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE RUN WHEN THE "Completeusersproof mv" BUTTON IS PRESSED

Completeusersproof_mv:
; Statements below this label "Completeusersproof_mv" are executed
; when the Completeusersproof_mv button is pressed.

{

IfWinNotExist,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

IfWinNotExist,ProofAsstGUI - proofWorksheetFF.mmp,,,, return

Sleep, 10
  
WinActivate,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet

Sleep, 10

WinWaitActive,ProofAsstGUI -,,3,ProofAsstGUI - proofWorksheet

Sleep, 10

IfWinNotActive,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

Send, {F10}{Down}{Down}{ENTER}

Sleep, 10

WinWaitActive, Save

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\proofWorksheet.txt{ENTER}

Sleep, 10

WinWaitActive, getYesNoAnswer()

Sleep, 10

Send, {ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.txt

Sleep, 10

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 10

WinWaitActive, Open

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\myproofs\proofWorksheet.mmp{ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 10

Run, c:\mmj2\mmj2jar\completeusersproofMv.bat
; Execute this .bat file. The value of argv[1] for this .bat file is
; "runCompleteusersproofmv". completeusersproof.exe is executed. The User's
; Proof is processed using the metavariable deduction unification means.

}

Sleep, 10

return
; The code enclosed in curly braces after the "Completeusersproof_mv" label is
; executed in response to the User's press of the "Completeusersproof mv"
; button.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE RUN WHEN THE "Stepprover" BUTTON IS PRESSED

Stepprover:
; Statements below this label "Stepprover" are executed
; when the "Stepprover" button is pressed.

{

IfWinNotExist,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

IfWinNotExist,ProofAsstGUI - proofWorksheetFF.mmp,,,, return

Sleep, 10
  
WinActivate,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet

Sleep, 10

WinWaitActive,ProofAsstGUI -,,3,ProofAsstGUI - proofWorksheet

Sleep, 10

IfWinNotActive,ProofAsstGUI -,,ProofAsstGUI - proofWorksheet,, return

Sleep, 10

Send, {F10}{Down}{Down}{ENTER}

Sleep, 10

WinWaitActive, Save

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\proofWorksheet.txt{ENTER}

Sleep, 10

WinWaitActive, getYesNoAnswer()

Sleep, 10

Send, {ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.txt

Sleep, 10

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 10

WinWaitActive, Open

Sleep, 10

Send, {BACKSPACE}c:\mmj2\mmj2jar\myproofs\proofWorksheet.mmp{ENTER}

Sleep, 10

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 10

Run, c:\mmj2\mmj2jar\completeusersproofSp.bat
; Execute this .bat file. The value of argv[1] for this .bat file is
; "runStepprover". completeusersproof.exe is executed. The User's Proof is
; processed by the stepprover() function alone.

}

Sleep, 10

return
; The code enclosed in curly braces after the "Stepprover" label is
; executed in response to the User's press of the "Stepprover"
; button.


; *****************************************************************************
; *****************************************************************************
; SUBROUTINE RUN WHEN THE "Exit/Quit" BUTTON IS PRESSED

Close:
; This is the glabel for the "Exit/Quit" button of the completeusersproof GUI.

ExitApp
; This exits the script. It has the same effect as choosing "Exit" in the
; system tray.

Sleep, 10

return














