
;  unifylong.ahk                Similar to unify.ahk. "unifylong.exe" is
;                               passed by a mmj2Unify() call when
;                               proofWorksheet has the value
;                               "duplicateUnificationThms.txt", which may
;                               be a very long Proof Worksheet requiring
;                               longer-than-normal pauses between button
;                               presses to allow mmj2 processes to
;                               complete.

Sleep, 480
; It has been found experimentally that greater reliability of the script is
; obtained if a Sleep statement of a minimum duration of 480 milliseconds
; immediately follows every non-Sleep statement. The instant Sleep statement,
; occurring before the first non-Sleep statement, serves a similar purpose.

WinWait, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 480

IfWinNotActive, ProofAsstGUI - proofWorksheet.mmp, , WinActivate, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 480

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 480

Send, {CTRLDOWN}p{CTRLUP}

Sleep, 480

WinWaitActive, Open,

Sleep, 480

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 480
 
WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,

Sleep, 2000

Send, {CTRLDOWN}up{CTRLUP}

Sleep, 2000
; An extra Sleep to make sure the last process completed.
;
; For duplicateUnificationThms.txt a longer pauses are needed than those
; sufficient for the shorter Proof Worksheets calling
; unify.exe and unifyFF.exe.
;
; For the instant Sleep and Sleeps below durations greater than 480 have been
; found by experimentation to be necessary for reliability of the script.

WinWaitActive, Open,

Sleep, 2000

Send, {ESCAPE}

Sleep, 2000

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 3000
; The next statement uses the unified proof. It is necessary that the
; unification process has completed before the next statement is executed
; otherwise the un-unified file will be saved, which is an error. As it
; turns out, at the moment of activation of "Open", the unification process
; is close to completion, but has not completed. The shorter duration
; Sleep of unify.ahk and unifyFF.ahk is sufficient for shorter Proof
; Worksheets, but is insufficient for the unification of
; duplicateUnificationThms.txt. This particular Sleep is especially important.

Send, {ENTER}{BACKSPACE}{CTRLDOWN}p{CTRLUP}

Sleep, 3000

WinWaitActive, getYesNo

Sleep, 3000

Send, {TAB}{TAB}{TAB}{ENTER}

Sleep, 3000

WinWaitActive, Open

Sleep, 3000
; Similar to above, this Sleep is necessary because the process of saving
; the proof is not complete at the moment "Open" becomes active. But the
; process does usually reliably complete within 3000 milliseconds of the "Open"
; window becoming active. This Sleep statement allows the process time to
; complete before execution proceeds to the next statement.
;
; If the save process does not complete before the next statement executes
; there will be an error. This error will likely corrupt the
; duplicateUnificationThms.txt file and possibility the proofWorksheet.mmp file.
; Corruption is manifiested by, upon opening the files, Textpad indicates
; that it has more lines than are observable. Another manifestation may be
; that the file becomes blank.
;
; Correct a corrupted file by saving another file as the name of the
; corrupted file. The copy() function of completeusersproof likely does not
; correct a corrupted file by overwriting it. The overwritten file may
; remain corrupted. If a once-corrupt file appears as long as the text editor
; indicates it to be, then it is no longer corrupt.
;
; In addition to correcting corrupted files, the two mmj2 running programs must
; be closed and rebooted after an error has occurred because one or more
; processes has insufficient time to complete. Also any ~zz text files generated
; in c:\mmj2\mmj2jar must be deleted in order for completeusersproof to run
; correctly.
;
; The longer duration of the instant Sleep is especially important for greater
; reliability of the script.

Send, {ESCAPE}

Sleep, 2400

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp

Sleep, 2400

return
