
;unify.ahk                      This AutoHotkey script file is invoked
;                               by a call of mmj2Unify() with the
;                               value "unify.exe" for the mmj2BatFile
;                               argument. It "presses" the buttons of the
;                               mmj2 instance without fd.txt loaded to
;                               open, unify, and save file which is
;                               the value of the proofWorksheet argument
;                               of the mmj2Unify() call.

WinWait, ProofAsstGUI - proofWorksheet.mmp,
; With this statement execution shall not proceed to the next statement until
; the window entitled "ProofAsstGUI - proofWorksheet.mmp" exists(is open and
; inactive or open and active)

Sleep, 480
; Provide a delay of at least 480 milliseconds after every statement to increase
; the probability of reliable performance of the script for a negligible cost.

IfWinNotActive, ProofAsstGUI - proofWorksheet.mmp, , WinActivate, ProofAsstGUI - proofWorksheet.mmp,
; The command WinActivate is executed iff the value of IfWinNotActive is true.
; IfWinNotActive is true if the argument window is not active. When this
; statement is reached, the window entitled "... proofWorksheet.mmp" exists,
; but may or may not be active. This statement activates the window
; "... proofWorksheet.mmp" if it is not already active.

Sleep, 480

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,
; The last command actives the proofWorksheet.mmp window if it is not active.
; It takes t milliseconds for the process of activating the window of this
; statement to complete. The next command will fail to execute if the process
; of activating the window has not completed because it requires the
; proofWorksheet.mmp window to be active. The instant command is necessary to
; insure that the proofWorksheet.mmp window is active before the next command
; is executed to insure that it executes successfully. The next Sleep statement
; is used to delay execution an additional 480 milliseconds to increase the
; probability that execution of the last process has completed before the next
; non-Sleep statement is executed.

Sleep, 480

Send, {CTRLDOWN}p{CTRLUP}
; This statement opens a new file and causes to exist and activates the window
; with entitled "Open".

Sleep, 480

WinWaitActive, Open,
; The process which activates the "Open" window has an unknown duration which
; depends on the system and the load on the system at the time of execution.
; This statement ensures that the next statement will not be executed until
; the "Open" window is active. This command specifies to not proceed to the
; next command until the window entitled "Open" is active. This statement is
; necessary because the next statement requires that the "Open" window is
; active. mmj2's purpose in activating the "Open" window is to request
; verification from the User that the named file is the one the User wishes
; to open.

Sleep, 480

Send, {TAB}{TAB}{TAB}{ENTER}
; The User's execution of the keystroke {ENTER} communicates to mmj2 that
; the file named in the window "Open" is, in fact, the file the User wishes
; opened. This statement executes that keystroke. It also causes the window
; "Open" to become non-existent after the process it opened for has completed.
; The proofWorksheet.mmp window became deactive when window "Open" became
; existent and active. This statement causes the proofWorksheet.mmp window
; to become active immediately after window "Open" becomes non-existent.

Sleep, 480
 
WinWaitActive, ProofAsstGUI - proofWorksheet.mmp,
; This statement delays execution of the next statement until the last
; statement has successfully completed execution. At the moment the process
; started by the last statement has completed proofWorksheet.mmp window
; becomes active. This statement makes the successful completion of the
; process started by the execution of the last statement probable and makes it
; probable that the next statement will not execute prematurely.

Sleep, 480

Send, {CTRLDOWN}up{CTRLUP}
; This statement starts the process of the mmj2-unification of the
; proofWorksheet.mmp Proof Worksheet and making existent and activating the
; "Open" window.

Sleep, 480

WinWaitActive, Open,
; This statement delays the execution of the next statement until the "Open"
; window becomes activated. It is assumed that the activate "Open" process
; is not initiated until the unify process has completed. It is assumed the
; command to activate "Open" is placed by mmj2 into a buffer and is executed
; the moment the unify process completes. The activate "Open" process
; completes the moment "Open" becomes active. It is assumed the command to
; open was sent about 10 milliseconds after the unify command was sent. Send
; sends keystrokes in sequence with a delay between each keystroke. It is
; assumed that the default delay between keystrokes is 10 milliseconds.
; Because "u" precedes "p" in the Send sequence, based on the assumptions,
; the unify process must be complete at the moment "Open" becomes active.

Sleep, 480

Send, {ESCAPE}
; This statement does the equivalent of pressing the "Cancel" button in the
; "Open" window. The "Yes" button must not be pressed because that would
; open the file before it was unified, overwriting the unified proof, which
; had never been saved. Pressing the "Cancel" button cancels the request to
; open the file as if it was never requested. This command does not execute
; until "Open" becomes active.

Sleep, 480

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp
; This statement delays the execution of the next statement until the
; process of cancelling "Open" has completed. When the process completes
; the "Open" window will close and the GUI window will activate. The save
; and open commands should not be sent until the GUI window is active.

Sleep, 480

Send, {ENTER}{BACKSPACE}{CTRLDOWN}p{CTRLUP}
; The purpose of Enter and Backspace is to cause Proof Worksheet have the
; state Edited. Then the open command will cause the popup "getYesNo" which
; offers the User an opportunity to save or not save the edited Proof
; Worksheet or lose the changes by not saving it. While the state of the
; Proof Worksheet becomes "Edited", the Proof Worksheet has not actually
; been edited because the Enter is reversed by the Backspace.

Sleep, 480

WinWaitActive, getYesNo
; Delay execution of the next statement until the "getYesNo" window becomes
; active. This window has a longer title, but a substring of the title is
; sufficient to identify it.

Sleep, 480

Send, {TAB}{TAB}{TAB}{ENTER}
; This statement is pressing the enter button which tells mmj2 that the User
; chooses to save the present Proof Worksheet before opening a new one. Tabs
; are used only because there is some evidence which appears to indicate that
; performance is more reliable with them than without them. While the truth
; of this is questionable, {TAB} is nevertheless used because its use is
; benign.

Sleep, 480

WinWaitActive, Open
; After the "getYesNoCancel" window closes the "Open" window should
; come into existence and become active. Delay executing the next statement
; until this happens, indicating that the Enter process has completed and
; the Proof Worksheet was saved.

Sleep, 960

Send, {ESCAPE}
; After "Open" becomes existent and active the proof had been saved. No file
; shall be opened, so the "Open" window is cancelled.

Sleep, 480

WinWaitActive, ProofAsstGUI - proofWorksheet.mmp
; When the "GUI .. " window becomes active the "Open" window has closed.
; The process of closing the "Open" window has completed. Execution then
; proceeds with the next statement, which is a Sleep to assure completion of
; the last process and then the return statement to end the script.

Sleep, 480

return
