#
#  MMStatement.py
#

# MMAStatement
#   kind -- "$a"
#   fhyps -- list of statement labels
#   ehyps -- list of statement labels
#   expression -- string of tokens
#   proofRefs -- empty string

# MMEStatement
#   kind -- "$e"
#   expression -- string of tokens

# MMFStatement
#   kind -- "$f"
#   expression -- string of two tokens

# MMPStatement
#   kind -- "$p"
#   fhyps -- list of statement labels
#   ehyps -- list of statement labels
#   expression -- string of tokens
#   proofRefs -- string of statement labels

class MMStatement(object):

    def __init__(self, statementLabel = None, statementDescription = "", **kwds):
        super(MMStatement, self).__init__(**kwds)
        self.statementLabel = statementLabel
        self.statementDescription = statementDescription

class MMHypothesis(MMStatement):

    def __init__(self, **kwds):
        super(MMHypothesis, self).__init__(**kwds)

class MMHypothesisE(MMHypothesis):

    def __init__(self, **kwds):
        super(MMHypothesisE, self).__init__(**kwds)
        self.statementType = "$e"
        self.statementStr = "" # string of tokens

    def setHypothesisE(self, statementStr = ""):
        self.statementStr = statementStr

class MMHypothesisF(MMHypothesis):

    def __init__(self, **kwds):
        super(MMHypothesisF, self).__init__(**kwds)
        self.statementType = "$f"
        self.statementStr = "" # string of tokens

    def setHypothesisF(self, statementStr = ""):
        self.statementStr = statementStr

class MMAssertion(MMStatement):

    def __init__(self, **kwds):
        super(MMAssertion, self).__init__(**kwds)

class MMAssertionA(MMAssertion):

    def __init__(self, **kwds):
        super(MMAssertionA, self).__init__(**kwds)
        self.statementType = "$a"
        self.fhyps = [] # list of labels
        self.ehyps = [] # list of labels
        self.statementStr = "" # string of tokens
        self.proofRefs = "" # string of labels
        self.proof = None # class MMProof

    def setAssertionA(self, fhyps = [], ehyps = [],
                statementStr = "", proofRefs = "", proof = None):
        self.fhyps = fhyps
        self.ehyps = ehyps
        self.statementStr = statementStr
        self.proofRefs = proofRefs
        self.proof = proof

class MMAssertionP(MMAssertion):

    def __init__(self, **kwds):
        super(MMAssertionP, self).__init__(**kwds)
        self.statementType = "$p"
        self.fhyps = [] # list of labels
        self.ehyps = [] # list of labels
        self.statementStr = "" # string of tokens
        self.proofRefs = "" # string of labels
        self.proof = None # class MMProof

    def setAssertionP(self, fhyps = [], ehyps = [],
                statementStr = "", proofRefs = "", proof = None):
        self.fhyps = fhyps
        self.ehyps = ehyps
        self.statementStr = statementStr
        self.proofRefs = proofRefs
        self.proof = proof

class MMExampleStatement(MMAssertionP): # wch: for testing only

    def __init__(self, **kwds):
        super(MMExampleStatement, self).__init__(**kwds)
        self.statementLabel = "19.32"
        self.statementDescription = "Theorem 19.32 of [Margaris] p. 90."+ 50*"$"+"@"
        fhyps = []
        ehyps = []
        statementStr = "|- ( ( ch -> ph ) <-> ( ch -> ps ) )"
        proofRefs = None
        proof = None
        self.setAssertionP(fhyps = fhyps, ehyps = ehyps,
                statementStr = statementStr,
                proofRefs = proofRefs, proof = proof)
