#
#  MMStatementView.py
#

import GUI
import WH.WHSnip
from MMStatementSnip import MMStatementSnip

class MMStatementView(WH.WHSnip.SnipView):

    def __init__(self, tokenImageDict = None, labelDict = None, **kwds):
        super(MMStatementView, self).__init__(**kwds)
        self.tokenImageDict = tokenImageDict
        self.labelDict = labelDict
        self._makeSnips(tokenImageDict)

    def setStatementContent(self, statement): # statement is type MMStatement
        if statement.statementType == "$p":
            self.statementSnip.setStatement(statement.statementLabel,
                statementType = statement.statementType,
                description = statement.statementDescription,
                fhyps = statement.fhyps,
                ehyps = statement.ehyps,
                statementStr = statement.statementStr,
                proofRefs = statement.proofRefs,
                proof = statement.proof,
                labelDict = self.labelDict,
                tokenImageDict = self.tokenImageDict)
        elif statement.statementType == "$a":
            self.statementSnip.setStatement(statement.statementLabel,
                statementType = statement.statementType,
                description = statement.statementDescription,
                fhyps = statement.fhyps,
                ehyps = statement.ehyps,
                statementStr = statement.statementStr,
                proofRefs = statement.proofRefs,
                proof = statement.proof,
                labelDict = self.labelDict,
                tokenImageDict = self.tokenImageDict)
        elif statement.statementType == "$e":
            self.statementSnip.setStatement(statement.statementLabel,
                statementType = statement.statementType,
                description = statement.statementDescription,
                fhyps = None,
                ehyps = None,
                statementStr = statement.statementStr,
                proofRefs = None,
                proof = None,
                labelDict = self.labelDict,
                tokenImageDict = self.tokenImageDict)
        elif statement.statementType == "$f":
            self.statementSnip.setStatement(statement.statementLabel,
                statementType = statement.statementType,
                description = statement.statementDescription,
                fhyps = None,
                ehyps = None,
                statementStr = statement.statementStr,
                proofRefs = None,
                proof = None,
                labelDict = self.labelDict,
                tokenImageDict = self.tokenImageDict)

    def refreshStatementContent(self): # relayout content
        self.statementSnip.refreshStatementContent()
        self.recalculateExtent()

    def syncWithModel(self):
        model = self.model
        self.model_changed(model)
        print model, "model"

###
### Overrides
###

    def mouse_down(self, event):
        x, y = event.position
        snip = self.findSnip(x, y)
        if snip:
            snipNode = self.snipDict[snip]['node']
            if isinstance(snip, WH.WHSnip.TextSnip):
                print snipNode.name, snip.name, snip.text
                if snip.name == "ItemRef":
                    self.window.document.viewStatementForLabel(snip.text)
            else:
                print snipNode.name

    def resized(self, (dw, dh)): # handle stretch horizontal and vertical
        return   # wch testing 060812 added
        print "StatementView resized", (dw, dh), "; current size", self.size
        width, height = self.size
        rootSnip = self.rootSnip
        contentMinW, contentMinH = rootSnip.getMinSize()
        contentPreferredW, contentPreferredH = rootSnip.getPreferredSize()
        contentW = max(contentPreferredW, contentMinW, width - 16)
        contentH = max(contentPreferredH, contentMinH, height - 16)
        rootSnip.setSize((contentW, contentH))
        self.layoutNode(self.rootNode)
        oldExtentL, oldExtentT, oldExtentR, oldExtentB = self.get_extent()
        oldWidth, oldHeight = oldExtentR - oldExtentL, oldExtentB - oldExtentT
        newWidth, newHeight = rootSnip.getSize()
        newExtentR = oldExtentR + newWidth - oldWidth
        newExtentB = oldExtentB + newHeight - oldHeight
        newExtent = (oldExtentL, oldExtentT, newExtentR, newExtentB)
        self.set_extent(newExtent)

###
### Utility methods
###

    def _makeSnips(self, tokenImageDict):
        backgroundNode = self.makeNode(name = "background",
            layout = WH.WHSnip.BoxLayoutManager(axis = 2))
        backgroundSnip = WH.WHSnip.Snip(name = backgroundNode.name,
            backgroundColor = None, foregroundColor = None,
            alignment = 0, fillHorizontal = True, fillVertical = True)
        self.pairNodeSnip(backgroundNode, backgroundSnip)
        self.rootNode.addChild(backgroundNode)

        self.contentNode = self.makeNode(name = "content",
            layout = WH.WHSnip.BoxLayoutManager(axis = 2))
        self.contentSnip = WH.WHSnip.Snip(name = self.contentNode.name,
            backgroundColor = GUI.StdColors.white, foregroundColor = None,
            alignment = 0, fillHorizontal = True, fillVertical = True)
        self.pairNodeSnip(self.contentNode, self.contentSnip)
        backgroundNode.addChild(self.contentNode)

        self.statementSnip = MMStatementSnip(self)
        self.statementNode = self.snipDict[self.statementSnip]["node"]
        self.contentNode.addChild(self.statementNode)
