#
#  MMTokenSnip.py
#

import GUI
import WH.WHSnip

class MMTokenSnip(WH.WHSnip.Snip):

    tokenSnipDict = {}

    def __init__(self, token, tokenImageDict, tokenColor = None, **kwds):
        super(MMTokenSnip, self).__init__(**kwds)
        self.token = token
        self.tokenImageDict = tokenImageDict
        self.tokenColor = tokenColor

        key = (token, tokenColor)
        if key in MMTokenSnip.tokenSnipDict:
            self.tokenPixmap = MMTokenSnip.tokenSnipDict[key]
        else:
            self.tokenPixmap = self.makePixmap(token, tokenColor, tokenImageDict)
            MMTokenSnip.tokenSnipDict[key] = self.tokenPixmap

        contentWidth = self.tokenPixmap.width
        contentHeight = self.tokenPixmap.height
        contentSize = (contentWidth, contentHeight)
        self.setContentSize(contentSize)
        self.setContentMinSize(contentSize)
        self.setContentPreferredSize(contentSize)

    def makePixmap(self, token, tokenColor, tokenImageDict):
        if token in tokenImageDict:
            tokenImage = tokenImageDict[token]
        else:
            tokenImage = tokenImageDict["xbox"]
        imageWidth = tokenImage.width
        imageHeight = tokenImage.height
        imageSize = (imageWidth, imageHeight)
        srcRect = GUI.Geometry.rect_sized((0,0), imageSize)

        backgroundPixmap = GUI.Pixmap(imageWidth, imageHeight)
        if tokenColor:
            def proc(c):
                c.forecolor = tokenColor
                c.fill_rect((0, 0, imageWidth, imageHeight))
            backgroundPixmap.with_canvas(proc)

        tokenPixmap = GUI.Pixmap(imageWidth, imageHeight)
        def proc2(c):
            tokenImage.draw(c, srcRect, srcRect)
            backgroundPixmap.draw(c, srcRect, srcRect)
        tokenPixmap.with_canvas(proc2)

        return tokenPixmap

    def drawContent(self, canvas, update_rect):
        #@canvas.gsave()
        contentLocation = self.getContentLocation()
        imageSize = self.getContentSize() # wch kludge
        srcRect = GUI.Geometry.rect_sized((0,0), imageSize)
        dstRect = GUI.Geometry.rect_sized(contentLocation, imageSize)
        self.tokenPixmap.draw(canvas, srcRect, dstRect)
        #@canvas.grestore()
