#
#  MMApplication.py
#

import GUI
import MM
import os
import sys
from MMDocument import MMDocument
from MMDocumentWindow import MMDocumentWindow

class MMApplication(GUI.Application):

    def __init__(self):
        super(MMApplication, self).__init__()
        self.app_dirname = os.path.abspath(os.path.dirname(sys.argv[0]))
        mmsFileType = GUI.FileType(name = "Metamath source database",
                suffix = "mms", mac_type = "mms ",
                mac_creator = "mmth")
        self.open_file_types.append(mmsFileType)
        tokenImageIterator = MM.TokenImageIterator("symbolImageDict.txt")
        self.tokenImageDict = dict(tokenImageIterator)
        print len(self.tokenImageDict), "self.tokenImageDict"
        if not self.menus: # wch: kludge fix
            self.menus = GUI.StdMenus.basic_menus() # wch: kludge fix

###
### Overrides of abstract methods
###

    def open_app(self):
        self.new_cmd()

    def make_document(self, fileref):
        mmDocument = MMDocument(self.tokenImageDict)
        if fileref is None:
            mmDocument.title = "set.mms" # wch: kludge
        return mmDocument

    def make_window(self, document):
        documentWindow = MMDocumentWindow(self.tokenImageDict, document = document)
        documentWindow.placeComponents()
        documentWindow.show()