#
#  MMDocumentWindow.py
#

import GUI
import MM
from WHTextView import WHTextView

import AppKit

class MMDocumentWindow(GUI.Window):

    def __init__(self, tokenImageDict, **kwds):
        super(MMDocumentWindow, self).__init__(**kwds)
        self.tokenImageDict = tokenImageDict

        # Make subviews
        self.buttonbarView = GUI.View()
        self.labelLabel = GUI.Label("label ")
        self.labelField = GUI.TextField(text = "", width = 300)
        self.documentPane = GUI.ScrollableView(scrolling = "hv",
                height = 400, width = 600)

        # Add subviews
        # This is needed so that subview.window is valid
        self.add(self.buttonbarView)
        self.buttonbarView.add(self.labelLabel)
        self.buttonbarView.add(self.labelField)
        self.add(self.documentPane)

        # Menu stuff
        self.make_menus() # wch: testing
        
        # Kludge stuff
        self.documentView = WHTextView(scrollableView = self.documentPane)
        self.documentPane._ns_inner_view = self.documentView._ns_view
        nsScrollView = self.documentPane._ns_view
        nsScrollView.setDocumentView_(self.documentPane._ns_inner_view)
        #nsScrollView.setBorderType_(AppKit.NSBezelBorder)
        #nsScrollView.setHasVerticalScroller_(True)
        #nsScrollView.setHasHorizontalScroller_(True)
        #nsScrollView.setAutoresizingMask_((AppKit.NSViewWidthSizable |
        #        AppKit.NSViewHeightSizable))
        #nsScrollView.contentView().setAutoresizesSubviews_(True)

        nsTextContainer = self.documentView._ns_view.textContainer()
        nsTextContainer.setWidthTracksTextView_(False)
        nsTextContainer.setHeightTracksTextView_(False)

        self.documentView._ns_view.setString_(self.document.sourceLines) # wch testing
            
    def placeComponents(self):
        vTab = 10
        self.buttonbarView.place(self.labelLabel,
                sticky = "nw",
                left = 0, top = 0)
        self.buttonbarView.place(self.labelField,
                sticky = "new",
                left = self.labelLabel, top = 0)
        self.buttonbarView.shrink_wrap() # wch: kludge
        self.place(self.buttonbarView, sticky = 'new',
                left = 0, top = vTab)
        self.place(self.documentPane, sticky = 'news',
                left = 0, top = self.buttonbarView + vTab)
        # Now right justifies subviews if needed
        contents = self.contents
        rights = [item.right for item in contents]
        bottoms = [item.bottom for item in contents]
        width, height = max(rights), max(bottoms)
        if self.documentPane.width < width:
            self.documentPane.resize(width = width)
        #if self.buttonbarView.width < width:
        #    self.buttonbarView.resize(width = width)
        # Now do the layout
        self.shrink_wrap()

###
### Menu command methods
###

    def make_menus(self):
        self.is_comment = True
        self.is_wff = False
        self.is_proof = True
        self.is_lemmon_style = True
        self.is_renumber = True
        self.is_reverse = False
        projectMenu = GUI.Menu("Project",
                    [
                        ("Verify database", 'verify_cmd'),
                        ("Compile", 'compile_cmd'),
                        ("Load compiled database", 'load_compiled_cmd'),
                        ("Save compiled database", 'save_compiled_cmd')
                    ]
                )
        statementMenu = GUI.Menu("Statement",
                    [
                        ("Comment/^C", 'comment_cmd'),
                        ("Wff/^W", 'wff_cmd'),
                        ("Proof/^P", 'proof_cmd')
                    ]
                )
        proofMenu = GUI.Menu("Proof",
                    [
                        ("Lemmon style/^L", 'lemmon_style_cmd'),
                        ("Renumber proof steps/^R", 'renumber_cmd'),
                        ("Reverse proof steps", 'reverse_cmd')
                    ]
                )
        testingMenu = GUI.Menu("Testing",
                    [
                        ("Show example statement", 'showExampleStatement_cmd')
                    ]
                )
        self.menus = [projectMenu, statementMenu, proofMenu, testingMenu]

    def verify_cmd(self):
        self.document.verifyDatabase()

    def compile_cmd(self):
        self.document.compile()

    def load_compiled_cmd(self):
        self.document.loadCompiled()

    def save_compiled_cmd(self):
        self.document.saveCompiled()

    def comment_cmd(self):
        self.is_comment = not self.is_comment

    def wff_cmd(self):
        self.is_wff = not self.is_wff

    def proof_cmd(self):
        self.is_proof = not self.is_proof

    def lemmon_style_cmd(self):
        self.is_lemmon_style = not self.is_lemmon_style

    def renumber_cmd(self):
        self.is_renumber = not self.is_renumber

    def reverse_cmd(self):
        self.is_reverse = not self.is_reverse

    def showExampleStatement_cmd(self):
        statement = MM.ExampleStatement()
        self.document.viewStatement(statement)

###
### Overriden methods
###

    def close_cmd(self):
        self.document.close_cmd()

    def setup_menus(self, m):
        m.close_cmd.enabled = True # wch: why is this needed?
        m.save_cmd.enabled = False # wch: testing [stub]
        m.save_as_cmd.enabled = False # wch: testing [stub]
        m.revert_cmd.enabled = False # wch: testing [stub]
        m.verify_cmd.enabled = self.document.sourceExists()
        m.compile_cmd.enabled = self.document.sourceExists()
        m.load_compiled_cmd.enabled = True
        m.save_compiled_cmd.enabled = (self.document.mmCompile != None)
        m.comment_cmd.enabled = True
        m.wff_cmd.enabled = True
        m.proof_cmd.enabled = True
        m.lemmon_style_cmd.enabled = True
        m.renumber_cmd.enabled = True
        m.reverse_cmd.enabled = True
        m.showExampleStatement_cmd.enabled = True

        m.comment_cmd.checked = self.is_comment
        m.wff_cmd.checked = self.is_wff
        m.proof_cmd.checked = self.is_proof
        m.lemmon_style_cmd.checked = self.is_lemmon_style
        m.renumber_cmd.checked = self.is_renumber
        m.reverse_cmd.checked = self.is_reverse

    def key_up(self, event):
        if event.char == '\r':
            text = self.labelField.text.rstrip('\r')
            text = text.strip()
            self.document.viewStatementForLabel(text)
