#
#  WHTextView.py
#
#  Created by William Hale on 7/31/06.
#  Copyright (c) 2006 William Hale. All rights reserved.
#

import GUI
from AppKit import NSViewNotSizable
from Foundation import NSRect, NSPoint, NSSize, NSObject, NSTextView, NSScrollView
from Foundation import NSMakeRect, NSString, NSMakeSize
from GUI.ViewBases import PyGUI_NS_ViewBase
from GUI.Utils import NSMultiClass

class WHTextView(GUI.Component, GUI.ViewBase):

    LargeNumberForText = 1.0e7

    def __init__(self, scrollableView = None, **kwds):
        self.scrollableView = scrollableView
        largeNumberForText = self.LargeNumberForText
        width, height = (largeNumberForText, largeNumberForText)
        ns_frame = NSMakeRect(0, 0, width, height)
        ns_view = PyGUI_TextView.alloc().initWithFrame_(ns_frame)
        ns_view.pygui_component = self
        ns_view.setEditable_(True)
        ns_view.setString_(NSString.stringWithString_(" "))
        GUI.Component.__init__(self, _ns_view = ns_view)
        self.set(**kwds)

        #ns_view.setMinSize_(NSMakeSize(40, 20))
        ns_view.setMaxSize_(NSMakeSize(largeNumberForText, largeNumberForText))
        ns_view.setHorizontallyResizable_(True)
        ns_view.setVerticallyResizable_(True)
        ns_view.setAutoresizingMask_(NSViewNotSizable)
        ns_view.setSelectable_(True)
        ns_view.setEditable_(True)
        ns_view.setRichText_(True)
        ns_view.setImportsGraphics_(True)
        ns_view.setUsesFontPanel_(True)
        ns_view.setUsesRuler_(True)
    
    def destroy(self):
        #print "View.destroy:", self ###
        ns_inner_view = self._ns_inner_view
        GUI.Component.destroy(self)
        if ns_inner_view:
            #print "View.destroy: breaking back link from", ns_inner_view ###
            ns_inner_view.pygui_component = None
    
    def invalidate(self):
        self._ns_inner_view.setNeedsDisplay_(True)
    
    def invalidate_rect(self, r):
        self._ns_inner_view.setNeedsDisplayInRect_(rect_to_ns_rect(r))

    def with_canvas(self, proc):
        ns_view = self._ns_view
        ns_view.lockFocus()
        proc(Canvas())
        ns_view.unlockFocus()
    
    def update(self):
        self._ns_view.displayIfNeeded()
    
    def next_handler(self):
        return self.scrollableView # wch: kludge? for menu handling

class PyGUI_Flipped:
    #  An NSView with a flipped coordinate system.
    
    def isFlipped(self):
        return True

class PyGUI_TextView(NSTextView, PyGUI_Flipped):
    __metaclass__ = NSMultiClass
    #
    #  pygui_component   TextView

class PyGUI_ScrollView(NSScrollView, PyGUI_Flipped):
    __metaclass__ = NSMultiClass
    #
    #  pygui_component   TextView
