#
#  WHLayoutManager.py
#
#  Created by William Hale on May 22, 2006.
#  Copyright 2006 William Hale. All rights reserved.
#

import GUI.Geometry

class WHLayoutManager(object):

    def __init__(self):
        super(WHLayoutManager, self).__init__()

    def getContentLayoutPreferredSize(self, node, nodeDict):
        ### Assume children have correct preferredSizes
        snip = nodeDict[node]['snip']
        contentMaxSize = snip.getContentMaxSize()
        contentMinSize = snip.getContentMinSize()
        contentLayoutRect = self.getContentLayoutRect(node, nodeDict)
        contentLayoutPreferredWidth, contentLayoutPreferredHeight = \
                GUI.Geometry.rect_size(contentLayoutRect)
        if contentMinSize:
            contentMinWidth, contentMinHeight = contentMinSize
            contentLayoutPreferredWidth = \
                    max(contentLayoutPreferredWidth, contentMinWidth)
            contentLayoutPreferredHeight = \
                    max(contentLayoutPreferredHeight, contentMinHeight)
        if contentMaxSize:
            contentMaxWidth, contentMaxHeight = contentMaxSize
            if contentMaxWidth:
                contentLayoutPreferredWidth = \
                        min(contentLayoutPreferredWidth, contentMaxWidth)
            if contentMaxHeight:
                contentLayoutPreferredHeight = \
                        min(contentLayoutPreferredHeight, contentMaxHeight)
        contentLayoutPreferredSize = \
                (contentLayoutPreferredWidth, contentLayoutPreferredHeight)
        return contentLayoutPreferredSize

    def setSnipPreferredSize(self, node, nodeDict):
        ### Assume children have correct preferredSizes
        contentLayoutPreferredSize = \
                self.getContentLayoutPreferredSize(node, nodeDict)
        snip = nodeDict[node]['snip']
        snip.setContentPreferredSize(contentLayoutPreferredSize)

    def layoutSnipChildren(self, node, nodeDict):
        ### Assume self has correct bounds
        ### Assume children have correct preferredSizes
        nodeSnip = nodeDict[node]['snip']
        nodeSnipWidth, nodeSnipHeight = nodeSnip.getSize()
        nodeSnipX, nodeSnipY = nodeSnip.getLocation()
        nodeSnipL, nodeSnipT, nodeSnipR, nodeSnipB = \
                nodeSnip.getContentBounds() # wch: testing borders
        nodeSnipWidth = nodeSnipR - nodeSnipL # wch: testing borders
        nodeSnipHeight = nodeSnipB - nodeSnipT # wch: testing borders
        nodeSnipX, nodeSnipY = nodeSnipL, nodeSnipT # wch: testing borders
        layoutRect = self.getContentLayoutRect(node, nodeDict)
        layoutRectX, layoutRectY = GUI.Geometry.rect_topleft(layoutRect)
        x = -layoutRectX
        y = -layoutRectY
        children = node.getChildren()
        for child in children:
            childSnip = nodeDict[child]['snip']
            childX, childY = x, y
            childWidth, childHeight = childSnip.getPreferredSize()
            childX += nodeSnipX ## wch testing
            childY += nodeSnipY ## wch testing
            childSnip.setLocation((childX, childY))
            childSnip.setSize((childWidth, childHeight))

    def isDirtyChildSnip(self, childSnip):
        return False

## utility methods

    def getContentLayoutRect(self, node, nodeDict):
        ### Assume children have correct preferredSizes
        max_childWidth = 0
        max_childHeight = 0
        children = node.getChildren()
        for child in children:
            childSnip = nodeDict[child]['snip']
            childWidth, childHeight = childSnip.getPreferredSize()
            max_childWidth = max(max_childWidth, childWidth)
            max_childHeight = max(max_childHeight, childHeight)
        origin = (0, 0)
        size = (max_childWidth, max_childHeight)
        result = GUI.Geometry.rect_sized(origin, size)
        return result
