#
#  WHNode.py
#

class WHNode(object):

    def __init__(self, name = ""):
        super(WHNode, self).__init__()
        self.parent = None
        self.children = list()
        self.name = name

    def __del__(self):
        if self.parent:
            print "Node", self.name, "has parent."
        if len(self.children):
            print "Node", self.name, "has children."
        #print self.name, "node destroyed"

    def __repr__(self): ## wch testing
        result = "["
        for child in self.children:
            result += child.name + " "
        return result + "]"

    def insertChild_atIndex(self, child, index):
        assert(child != None)
        assert(child.parent is None)
        assert(child != self)
        self.children.insert(index, child)
        child.parent = self

    def removeChild_atIndex(self, index):
        child = self.children.pop(index)
        child.parent = None

    def childrenCount(self):
        return len(self.children)

    def getChildren(self):
        return self.children

    def getRoot(self):
        result = self;
        if result.parent:
            result = result.parent.getRoot();
        return result;

    def getParent(self):
        return self.parent

    def getFirstChild(self):
        result = None
        if len(self.children):
            result = self.children[0]
        return result

    def getLastChild(self):
        result = None
        if len(self.children):
            result = self.children[-1]
        return result

    def getChildAfter(self, otherChild):
        result = None
        index = self.children.index(otherChild)
        if 0 <= index < len(self.children) - 1:
            result = self.children[index+1]
        return result

    def getChildBefore(self, otherChild):
        result = None
        index = self.children.index(otherChild)
        if 0 < index < len(self.children):
            result = self.children[index - 1]
        return result

    def getChildAtIndex(self, index):
        result = self.children[index]
        return result

    def preorderGenerator(self, action = None): # generator function
        result = True
        if action: result = action(self)
        if result:
            yield self
            for child in self.children:
                for item in child.preorderGenerator(action):
                    yield item

    def postorderGenerator(self): # generator function
        for child in self.children:
            for item in child.postorderGenerator():
                yield item
        yield self

    # utility methods

    def addChild(self, child):
        index = self.childrenCount()
        self.insertChild_atIndex(child, index)

    def addChild_after(self, child, otherChild):
        try:
            index = self.children.index(otherChild) + 1
        except ValueError:
             index = 0
        self.insertChild_atIndex(child, index)

    def addChild_before(self, child, otherChild):
        try:
            index = self.children.index(otherChild)
        except ValueError:
            index = self.childrenCount()
        self.insertChild_atIndex(child, index)

    def removeChild(self, child):
        try:
            index = self.children.index(child)
            self.removeChild_atIndex(index)
        except ValueError:
            pass

    def removeFromParent(self):
        if self.parent:
            index = self.parent.children.index(self)
            self.parent.removeChild_atIndex(index)

    def isDescendantOf(self, node):
        if self is node:
            result = True
        elif self.parent is None:
            result = False
        else:
            result = self.parent.isDescendantOf(node)
        return result
