#
#  WHSnipView.py
#

import GUI
from WHSnip import WHSnip
from WHNode import WHNode
from WHBoxLayoutManager import WHBoxLayoutManager
from WHLayoutManager import WHLayoutManager

class WHSnipView(GUI.ScrollableView): # wch: not really a container, just a component

    def __init__(self, **kwds):
        super(WHSnipView, self).__init__(**kwds)
        self.nodeDict = {}
        self.snipDict = {}
        self.selectSiteNodes = []
        self.dragSiteNodes = []
        self.targetSiteNodes = []

        self.rootNode = self.makeNode(name = "root",
            layout = WHBoxLayoutManager(axis = 0))
        self.rootSnip = WHSnip(name = self.rootNode.name)
        self.pairNodeSnip(self.rootNode, self.rootSnip)

        self.rootSnip.setMinSize((1, 1)) # wch: kludge
        self.size = (17, 17) # wch: kludge because default size is (100, 100)

        ### wch debugging gc
        import gc
        print "number of unreachable objects =", gc.collect()
        print "len(gc.garbage) =", len(gc.garbage)
        print "len(gc.get_objects()) =", len(gc.get_objects())

    def __del__(self):
        print "SnipView destroyed start"
        import gc
        print "number of unreachable objects =", gc.collect()
        print "len(gc.garbage) =", len(gc.garbage)
        print "len(gc.get_objects()) =", len(gc.get_objects())
        for node in self.nodeDict.iterkeys():
            node.removeFromParent()
        self.nodeDict.clear()
        import gc
        print "number of unreachable objects =", gc.collect()
        print "len(gc.garbage) =", len(gc.garbage)
        print "len(gc.get_objects()) =", len(gc.get_objects())
        print "SnipView destroyed ended"

    def getNode(self, nodeName):
        result = None
        for node in self.nodeDict.iterkeys():
            if node.name == nodeName:
                result = node
                break
        return result

    def findSnip(self, x, y):
        rootNode = self.rootNode
        nodes = reversed([node for node in rootNode.preorderGenerator()])
        for node in nodes: 
            snip = self.nodeDict[node]['snip']
            if snip.contains(x, y):
                return snip
        return None

    def getClipBoundsForNode(self, node):
        nodeParent = node.getParent()
        snip = self.nodeDict[node]['snip']
        result = snip.getBounds()
        if nodeParent:
            parentClibBounds = self.getClipBoundsForNode(nodeParent)
            result = GUI.Geometry.sect_rect(result, parentClibBounds)
        return result

    def getAncestorOfNode_fromNodes(self, node, nodes):
        result = None
        if node:
            for itemNode in nodes:
                if node.isDescendantOf(itemNode):
                    result = itemNode
                    break
        return result

    def layoutNode(self, node):  ## wch testing
        for itemNode in node.postorderGenerator():
            itemLayout = self.nodeDict[itemNode].get('layout', None)
            if itemLayout:
                itemLayout.setSnipPreferredSize(itemNode, self.nodeDict)
        for itemNode in node.preorderGenerator():
            itemLayout = self.nodeDict[itemNode].get('layout', None)
            if itemLayout:
                itemLayout.layoutSnipChildren(itemNode, self.nodeDict)

###
### Messages sent by model
###

    def insertPieceMessage(self, model, pieceName, index, squareName):
        parentNode = self.getNode(squareName)
        itemNode = self.getNode(pieceName)
        parentNode.insertChild_atIndex(itemNode, index)

    def removePieceMessage(self, model, pieceName, index, squareName):
        parentNode = self.getNode(squareName)
        itemNode = self.getNode(pieceName)
        parentNode.removeChild(itemNode)

    def model_changed(self, model = None):
        rootNode = self.rootNode  ## wch TESTING
        self.layoutNode(rootNode)  ## wch TESTING
        self.invalidate()  # wch TESTING
        self.update()  # wch TESTING

###
### Overrides
###

    def draw99(self, canvas, update_rect):
        if GUI.Geometry.empty_rect(update_rect):
            return
        #print "start update_rect", update_rect, self.bounds
        def drawAction(node):
            snip = self.nodeDict[node]['snip']
            result = snip.intersects(update_rect)
            if result:
                #canvas.gsave() ### wch TESTING
                snip.draw(canvas, update_rect)
                #canvas.grestore() ### wch TESTING
            return result
        rootNode = self.rootNode
        counter = 0
        for itemNode in rootNode.preorderGenerator(drawAction):
            counter += 1
            pass
        #print "done", counter

    def draw(self, canvas, update_rect):
        if GUI.Geometry.empty_rect(update_rect):
            return
        #print "start update_rect", update_rect, self.bounds
        def drawAction(node):
            snip = self.nodeDict[node]['snip']
            result = snip.intersects(update_rect)
            if result:
                itemSnipClipBounds = self.getClipBoundsForNode(node)
                clipped_update_rect = GUI.Geometry.sect_rect(itemSnipClipBounds, update_rect)
                #canvas.gsave() ### wch TESTING
                #@canvas.rectclip(clipped_update_rect) ### wch TESTING
                snip.draw(canvas, clipped_update_rect)
                #canvas.grestore() ### wch TESTING
            return result
        rootNode = self.rootNode
        counter = 0
        for itemNode in rootNode.preorderGenerator(drawAction):
            counter += 1
            pass
        #print "done", counter

    def mouse_down(self, event):
        x, y = event.position
        snip = self.findSnip(x, y)
        if snip:
            snipNode = self.snipDict[snip]['node']
            print snipNode.name

###
### Utility methods
###

    def getExtentSize(self):
        (l, t, r, b) = self.extent
        return (r - l, b - t)

    def recalculateExtent(self):
        self.layoutNode(self.rootNode)
        rootSnip = self.rootSnip
        rootWishWidth, rootWishHeight = rootSnip.getWishSize()
        newExtent = (0, 0, rootWishWidth, rootWishHeight)
        self.set_extent(newExtent)
        rootSnip.setSize((rootWishWidth, rootWishHeight)) # wch: testing
        self.layoutNode(self.rootNode) # wch: testing
        print "recalculateExtent", (rootWishWidth, rootWishHeight)

    def makeNode(self, name = "", layout = None):
        node = WHNode(name)
        self.nodeDict[node] = {}
        self.nodeDict[node]['layout'] = layout
        return node

    def pairNodeSnip(self, node, snip):
        self.nodeDict[node]['snip'] = snip
        self.snipDict[snip] = {}
        self.snipDict[snip]['node'] = node
