#
#  MMTokenImageIterator.py
#

import GUI
import os
import WH.WHSnip

class MMTokenImageIterator(object):
    def __init__(self, fileName):
        self.fileName = fileName
        self.iterator = self._next()
        self.next = self.iterator.next
 
    def _next(self):
        print "start loading images"
        app_dirname = GUI.application().app_dirname
        symbolImageDictFile = open(app_dirname + "/" + self.fileName)
        symbolImageDictToks = MMToks(symbolImageDictFile)
        missingToken = "xbox"
        missingTokenFile = "xbox.gif"
        try:
            missingTokenImage = WH.WHSnip.Image(file =
                    app_dirname + "/Symbol Images/" + missingTokenFile)
            yield (missingToken, missingTokenImage)
        except Exception, exception:
            #print missingToken, "has no image", exception
            pass
        result = self.readToks(symbolImageDictToks)
        while result:
            if result[0] and result[1] and result[2]:
                token = result[1]
                tokenFile = result[2]
                #if tokenFile[0] == "_":
                #   tokenFile = tokenFile[1:]
                #tokenFile = tokenFile.replace('gif', 'png')
                imageFile = app_dirname + "/Symbol Images/" + tokenFile
                if not os.path.exists(imageFile):
                    imageFile = app_dirname + "/Symbol Images/" + token + ".gif"
                    if not os.path.exists(imageFile):
                        print token
                try:
                    tokenImage = WH.WHSnip.Image(file = imageFile)
                    yield (token, tokenImage)
                except Exception, exception:
                    #print token, "has no image", exception
                    tokenImage = WH.WHSnip.Image(file =
                        app_dirname + "/Symbol Images/" + missingTokenFile)
                    yield (token, tokenImage)
                    pass
            result = self.readToks(symbolImageDictToks)
        symbolImageDictFile.close()
        print "end loading images"
   
    def __iter__(self):
        return self.iterator

    def readcToks(self, toks):
        while 1:
            tok = toks.read()
            if tok == None:
                return None
            if tok == '/*':
                while 1:
                    tok = toks.read()
                    if tok == '*/':
                        break
            else:
                return tok

    def readToks(self, toks):
        htmlDef = None
        symbol = None
        symbolImageFile = None
        while 1:
            tok = self.readcToks(toks)
            if tok == None:
                return None
            if tok == ';':
                break
            elif tok == 'htmldef':
                htmlDef = tok
                symbol = self.readcToks(toks)
                symbol = symbol[1:-1]
            elif tok == 'SRC=':
                symbolImageFile = self.readcToks(toks)
                symbolImageFile = symbolImageFile[1:-1]
        return (htmlDef, symbol, symbolImageFile)

class MMToks:
    def __init__(self, lines):
        self.lines = lines
        self.tokbuf = []
    def read(self):
        while self.tokbuf == []:
            line = self.lines.readline()
            if line == '':
                return None
            line = line.replace('/*', ' /* ')
            line = line.replace('*/', ' */ ')
            line = line.replace(';', ' ; ')
            line = line.replace('SRC=', ' SRC= ')
            self.tokbuf = line.split()
            self.tokbuf.reverse()
        return self.tokbuf.pop()
