#
#  MMDocument.py
#

import GUI
import MM
from MMStatementWindow import MMStatementWindow

class MMDocument(GUI.Document):

    def __init__(self, tokenImageDict, **kwds):
        super(MMDocument, self).__init__(**kwds)
        self.tokenImageDict = tokenImageDict
        self.sourceLines = ""
        self.labelDict = {}
        self.mmCompile = None

###
### Overrides of abstract methods
###

    def new_contents(self):
        pass

    def read_contents(self, file):
        self.sourceLines = file.read()
        print len(self.sourceLines)

    def write_contents(self, file):
        pass

    def destroy_contents(self):
        for w in self.windows:
            print w
        print "destroy_contents" # wch: stub

###
### methods
###

    def sourceExists(self):
        return len(self.sourceLines) > 0

    def verifyDatabase(self): # wch: needs more work
        print "begin verify Database"
        mmCompile = MM.Compile()
        mmCompile.read(MM.toks(self.sourceLines))
        for symbol in mmCompile.symbolSet:
            if symbol not in self.tokenImageDict:
                print "Symbol not found in symbolImageDict.txt:", symbol
        print "end verify Database"

    def compile(self):
        print "begin compile"
        self.mmCompile = MM.Compile()
        self.mmCompile.read(MM.toks(self.sourceLines))
        self.labelDict = self.mmCompile.labelDict
        for symbol in self.mmCompile.symbolSet:
            if symbol not in self.tokenImageDict:
                print "Symbol not found in symbolImageDict.txt:", symbol
        print "end compile", len(self.labelDict)

    def loadCompiled(self):
        self.labelDict = {}
        fileRef = self.file
        if fileRef:
            basename = fileRef.name.rstrip(".mms")
        else:
            basename = "set" #wch: kludge
        app_dirname = GUI.application().app_dirname
        compiledFile = open(app_dirname + "/" + basename + ".mmo", "r")
        for line in compiledFile:
            itemTuple = eval(line)
            label = itemTuple[0]
            rest = itemTuple[1]
            self.labelDict[label] = rest

    def saveCompiled(self):
        fileRef = self.file
        if fileRef:
            basename = fileRef.name.rstrip(".mms")
        else:
            basename = None
        print "basename", basename, self.mmCompile
        if self.mmCompile and basename: # wch stub
            self.mmCompile.writeLabelDict(basename)

    def getStatementForLabel(self, statementLabel):
        result = None
        statementData = self.labelDict[statementLabel]
        statementType = statementData[0]
        statementDescription = statementData[1]
        if statementType == "$p":
            fhyps = statementData[2]
            ehyps = statementData[3]
            statementStr = statementData[4]
            proofRefs = statementData[5]
            proof = MM.Proof(statementLabel, statementType, statementStr,
                    proofRefs, self.labelDict)
            assertionP = MM.AssertionP(statementLabel = statementLabel,
                    statementDescription = statementDescription)
            assertionP.setAssertionP(fhyps = fhyps, ehyps = ehyps,
                    statementStr = statementStr,
                    proofRefs = proofRefs, proof = proof)
            result = assertionP
        elif statementType == "$a":
            fhyps = statementData[2]
            ehyps = statementData[3]
            statementStr = statementData[4]
            proofRefs = statementData[5]
            proof = None
            print "$a", fhyps, ehyps, statementStr
            assertionA = MM.AssertionA(statementLabel = statementLabel,
                    statementDescription = statementDescription)
            assertionA.setAssertionA(fhyps = fhyps, ehyps = ehyps,
                    statementStr = statementStr,
                    proofRefs = proofRefs, proof = proof)
            result = assertionA
        elif statementType == "$e":
            statementStr = statementData[2]
            hypothesisE = MM.HypothesisE(statementLabel = statementLabel,
                    statementDescription = statementDescription)
            hypothesisE.setHypothesisE(statementStr = statementStr)
            result = hypothesisE
        elif statementType == "$f":
            statementStr = statementData[2]
            hypothesisF = MM.HypothesisF(statementLabel = statementLabel,
                    statementDescription = statementDescription)
            hypothesisF.setHypothesisF(statementStr = statementStr)
            result = hypothesisF
        return result

    def viewStatementForLabel(self, statementLabel):
        statement = self.getStatementForLabel(statementLabel)
        if statement:
            self.viewStatement(statement)

    def viewStatement(self, statement):
        statementWindow = MMStatementWindow(self.tokenImageDict, document = self)
        statementWindow.setStatementContent(statement)
        statementWindow.refreshStatementContent()
        statementWindow.placeComponents()
        statementWindow.show()