#
#  MMStatementWindow.py
#

import GUI
import WH
import MM
from AppKit import NSScreen

class MMStatementWindow(GUI.Window):

    def __init__(self, tokenImageDict, **kwds):
        super(MMStatementWindow, self).__init__(**kwds)
        
        #self.auto_position = False # wch: for testing purpose
        #self.position = (30, 30) # wch: for testing purpose
        self.size = (600, 600) # wch: testing

        # Make subviews
        self.buttonbarView = GUI.View()
        self.labelLabel = GUI.Label("label ")
        self.labelField = GUI.TextField(text = "", width = 200)
        self.horizontalLine = WH.HorizontalLineView()
        self.statementView = MM.StatementView(tokenImageDict = tokenImageDict,
                scrolling = "hv",
                labelDict = self.document.labelDict)
        self.statementView.add_model(self.document) # wch: who will remove_model?

        # Add subviews
        # This is needed so that statementView.window is valid
        self.add(self.buttonbarView)
        self.buttonbarView.add(self.labelLabel)
        self.buttonbarView.add(self.labelField)
        self.add(self.horizontalLine)
        self.add(self.statementView)

        # Menu stuff
        self.make_menus() # wch: testing

        # Miscellaneous stuff
        self.statementView.syncWithModel() # wch: where should this go?
            
    def placeComponents(self):
        vTab = 10
        self.buttonbarView.place(self.labelLabel,
                #@sticky = "nw",
                left = 0, top = 0)
        self.buttonbarView.place(self.labelField,
                #@sticky = "new",
                sticky = "new",
                left = self.labelLabel, top = 0)
        # Now must set size of buttonbarView
        self.buttonbarView.shrink_wrap() # wch: kludge
        # Now must set size of statementView
        buttonbarHeight = self.buttonbarView.height
        extentSizeWidth, extentSizeHeight = self.statementView.getExtentSize() # wch: kludge
        nsScreenRect = NSScreen.mainScreen().visibleFrame()
        (screenX, screenY), (screenWidth, screenHeight) = nsScreenRect
        extentSizeHeight = min(extentSizeHeight,
                screenHeight - buttonbarHeight - 50) # wch: super kludge
        #@self.statementView.size = (extentSizeWidth + 16, extentSizeHeight + 16) # wch: kludge
        self.statementView.size = (
            min(800, extentSizeWidth + 16),
            min(600, extentSizeHeight + 16)) # wch: kludge
        # Now must place subviews
        self.place(self.buttonbarView,
            #@sticky = 'new',
            sticky = 'new',
            left = 0, top = vTab)
        self.place(self.horizontalLine,
            #@sticky = 'new',
            sticky = 'new',
            left = 0, top = self.buttonbarView + vTab)
        self.place(self.statementView,
            #wch temporarily comment out:sticky = 'news',
            sticky = 'news',
            left = 0, top = self.horizontalLine)
        # Now right justifies subviews if needed
        contents = self.contents
        rights = [item.right for item in contents]
        bottoms = [item.bottom for item in contents]
        width, height = max(rights), max(bottoms)
        if self.buttonbarView.width < width:
            #@self.buttonbarView.resize(width = width)
            pass
        if self.statementView.width < width:
            #@self.statementView.resize(width = width)
            pass
        #self.horizontalLine.resize(width =
        #    max(self.buttonbarView.width, self.statementView.width))
        self.horizontalLine.resize(width = self.statementView.width)
        # Now do the layout
        self.shrink_wrap()
        
    def setStatementContent(self, statement): # statement is type MMStatement
        databaseName = self.document.title.rstrip(".mms")
        self.title = statement.statementLabel + " - " + databaseName
        self.statementView.setStatementContent(statement)
        
    def refreshStatementContent(self): # relayout content
        self.statementView.refreshStatementContent()
        #@self.placeComponents() # wch testing
        self._ns_view.setNeedsDisplay_(True) # wch: kludge

###
### Menu command methods
###

    def make_menus(self):
        mainDocumentWindow = self.document.windows[0]
        self.is_comment = mainDocumentWindow.is_comment
        self.is_wff = mainDocumentWindow.is_wff
        self.is_proof = mainDocumentWindow.is_proof
        self.is_lemmon_style = mainDocumentWindow.is_lemmon_style
        self.is_renumber = mainDocumentWindow.is_renumber
        self.is_reverse = mainDocumentWindow.is_reverse
        statementMenu = GUI.Menu("Statement",
                    [
                        ("Comment/^C", 'comment_cmd'),
                        ("Wff/^W", 'wff_cmd'),
                        ("Proof/^P", 'proof_cmd')
                    ]
                )
        proofMenu = GUI.Menu("Proof",
                    [
                        ("Lemmon style/^L", 'lemmon_style_cmd'),
                        ("Renumber proof steps/^R", 'renumber_cmd'),
                        ("Reverse proof steps", 'reverse_cmd')
                    ]
                )
        self.menus = [statementMenu, proofMenu]

    def comment_cmd(self):
        self.is_comment = not self.is_comment
        self.refreshStatementContent()

    def wff_cmd(self):
        self.is_wff = not self.is_wff
        self.refreshStatementContent()

    def proof_cmd(self):
        self.is_proof = not self.is_proof
        self.refreshStatementContent()

    def lemmon_style_cmd(self):
        self.is_lemmon_style = not self.is_lemmon_style
        self.refreshStatementContent()

    def renumber_cmd(self):
        self.is_renumber = not self.is_renumber
        self.refreshStatementContent()

    def reverse_cmd(self):
        self.is_reverse = not self.is_reverse
        self.refreshStatementContent()

###
### Overriden methods
###

    def setup_menus(self, m):
        m.close_cmd.enabled = True # wch: why is this needed?
        m.save_cmd.enabled = False # wch: testing [stub]
        m.save_as_cmd.enabled = False # wch: testing [stub]
        m.revert_cmd.enabled = False # wch: testing [stub]
        m.comment_cmd.enabled = True
        m.wff_cmd.enabled = True
        m.proof_cmd.enabled = True
        m.lemmon_style_cmd.enabled = True
        m.renumber_cmd.enabled = True
        m.reverse_cmd.enabled = True
        m.comment_cmd.checked = self.is_comment
        m.wff_cmd.checked = self.is_wff
        m.proof_cmd.checked = self.is_proof
        m.lemmon_style_cmd.checked = self.is_lemmon_style
        m.renumber_cmd.checked = self.is_renumber
        m.reverse_cmd.checked = self.is_reverse

    def key_up(self, event): # wch: kludge, labelField should handle this
        if event.char == '\r':
            text = self.labelField.text.rstrip('\r')
            text = text.strip()            
            if event.shift:
                # view statement in new window
                self.document.viewStatementForLabel(text)
            else:
                # view statement in same window
                statement = self.document.getStatementForLabel(text)
                self.setStatementContent(statement)
                self.refreshStatementContent()