#
#  WHBoxLayoutManager.py
#
#  Created by William Hale on May 22, 2006.
#  Copyright 2006 William Hale. All rights reserved.
#

import GUI.Geometry
from WHLayoutManager import WHLayoutManager

class WHBoxLayoutManager(WHLayoutManager):

    def __init__(self, axis = 0, dx = 0, dy = 0):
        super(WHBoxLayoutManager, self).__init__()
        self.axis = axis ## 0 for none, 1 for horizontal, 2 for vertical, 3 for both
        self.dx = dx
        self.dy = dy

    def layoutSnipChildren(self, node, nodeDict):
        ### Assume self has correct bounds
        ### Assume children have correct preferredSizes
        nodeSnip = nodeDict[node]['snip']
        nodeSnipWidth, nodeSnipHeight = nodeSnip.getSize()
        nodeSnipX, nodeSnipY = nodeSnip.getLocation()
        nodeSnipL, nodeSnipT, nodeSnipR, nodeSnipB = nodeSnip.getContentBounds() # wch: testing borders
        nodeSnipWidth = nodeSnipR - nodeSnipL # wch: testing borders
        nodeSnipHeight = nodeSnipB - nodeSnipT # wch: testing borders
        nodeSnipX, nodeSnipY = nodeSnipL, nodeSnipT # wch: testing borders
        layoutRect = self.getContentLayoutRect(node, nodeDict)
        layoutRectX, layoutRectY = GUI.Geometry.rect_topleft(layoutRect)
        x = -layoutRectX
        y = -layoutRectY
        children = node.getChildren()
        for child in children:
            childSnip = nodeDict[child]['snip']
            childX, childY = x, y
            childWidth, childHeight = childSnip.getPreferredSize()
            
            if childWidth != 0: x += self.dx
            if childHeight != 0: y += self.dy
            if self.axis & 1: x += childWidth
            if self.axis & 2: y += childHeight
            
            childHeight = self.fillChildHeight(childHeight,
                        childY = childY,
                        childFillVertical = childSnip.fillVertical,
                        parentHeight = nodeSnipHeight)
            childWidth = self.fillChildWidth(childWidth,
                        childX = childX,
                        childFillHorizontal = childSnip.fillHorizontal,
                        parentWidth = nodeSnipWidth)
            childX = self.alignChildX(childX,
                        childWidth = childWidth,
                        childAlignment = childSnip.alignment,
                        parentWidth = nodeSnipWidth)
            childY = self.alignChildY(childY,
                        childHeight = childHeight,
                        childAlignment = childSnip.alignment,
                        parentHeight = nodeSnipHeight)
            childX += nodeSnipX ## wch testing
            childY += nodeSnipY ## wch testing
            childSnip.setLocation((childX, childY))
            childSnip.setSize((childWidth, childHeight))

    def isDirtyChildSnip(self, childSnip):
        return False

## utility methods

    def getContentLayoutRect(self, node, nodeDict):
        ### Assume children have correct preferredSizes
        x0 = 0 ## current left x
        x1 = x0 ## current right x
        min_x0 = x0 ## min left x
        max_x1 = x1 ## max right x
        y0 = 0
        y1 = y0
        min_y0 = y0
        max_y1 = y1
        children = node.getChildren()
        for child in children:
            childSnip = nodeDict[child]['snip']
            childWidth, childHeight = childSnip.getPreferredSize()
            x1 = x0 + childWidth
            y1 = y0 + childHeight
            min_x0 = min(min_x0, x0)
            min_y0 = min(min_y0, y0)
            max_x1 = max(max_x1, x1)
            max_y1 = max(max_y1, y1)
            if self.axis & 1:
                x0 += childWidth
            if self.axis & 2:
                y0 += childHeight
            if childWidth != 0:
                x0 += self.dx
            if childHeight != 0:
                y0 += self.dy
        origin = (min_x0, min_y0)
        size = (max_x1 - min_x0, max_y1 - min_y0)
        size = (max_x1 - min_x0, max_y1 - min_y0)
        result = GUI.Geometry.rect_sized(origin, size)
        return result

    def fillChildHeight(self, childHeight, childY, childFillVertical, parentHeight):
        result = childHeight
        if childFillVertical and childHeight < parentHeight:
            result = parentHeight - childY ## wch testing
        return result

    def fillChildWidth(self, childWidth, childX, childFillHorizontal, parentWidth):
        result = childWidth
        if childFillHorizontal and childWidth < parentWidth:
            result = parentWidth - childX ## wch testing
        return result

    def alignChildX(self, childX, childWidth, childAlignment, parentWidth):
        result = childX
        if childAlignment % 3 == 1:
            result = (parentWidth - childWidth) / 2.0
        if childAlignment % 3 == 2:
            result = parentWidth - childWidth
        return result

    def  alignChildY(self, childY, childHeight, childAlignment, parentHeight):
        result = childY
        if childAlignment // 3 == 1:
            result = (parentHeight - childHeight) / 2.0
        if childAlignment // 3 == 2:
            result = parentHeight - childHeight
        return result
