#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Micha Trzsiok     Akademia Ekonomiczna w Katowicach
#*  
#*  Przykad do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(MASS)
library(class)
library(e1071)
data(iris)
names(iris) <- c("ddk","sdk","dp","sp","klasa")
attach(iris)
options(OutDec=",")
set.seed(111)
indeks <- sample(1:nrow(iris), 1)
print(paste("Ze zbioru uczcego wybrano obserwacj nr:", indeks), quote=FALSE)
nowy <- iris[indeks,]
print(paste("Naley ona do gatunku:", nowy$klasa), quote=FALSE)
iris149 <- iris[-indeks,]
#Najlepszy model SVM z funkcj jdrow Gaussa:
svm.iris <- tune.svm(klasa ~ ., data=iris149, kernel = "radial", gamma=c(0.5, 1), cost=10^(-2:2), tunecontrol=tune.control(sampling="cross", cross=3))
print(summary(svm.iris))
#Funkcja signif daje dwie cyfry znaczce:
print(paste("Najmniejszy bd klasyfikacji dla funkcji jdrowej Gaussa:", signif(svm.iris$best.performance, digits=2)), quote=FALSE)
print("Parametry tego modelu SVM:", quote=FALSE)
print(svm.iris$best.parameters)
#Zapamitanie najlepszego z dotychczas zbudowanych modeli:
najl.model <- svm.iris$best.model
min.err <- svm.iris$best.performance
#Najlepszy model SVM z wykorzystaniem wielomianowej funkcji jdrowej:
svm.iris <- tune.svm(klasa ~ ., data=iris149, kernel = "polynomial", degree=(2:5), gamma=c(0.5, 1), coef0=10, cost=10^(-2:2), tunecontrol=tune.control(sampling="cross", cross=3))
print(paste("Najmniejszy bd klasyfikacji dla wielomianowej funkcji jdrowej:", signif(svm.iris$best.performance, digits=2)), quote=FALSE)
print("Parametry tego modelu SVM:", quote=FALSE)
print(svm.iris$best.parameters)
#Jeli zbudowano model lepszy od najlepszego z wczeniej rozwaonych to zapamitujemy go:
if (svm.iris$best.performance < min.err) {najl.model <- svm.iris$best.model; min.err <- svm.iris$best.performance}
#Najlepszy model SVM z wykorzystaniem sigmoidalnej funkcji jdrowej:
svm.iris <- tune.svm(klasa ~ ., data=iris149, kernel = "sigmoid", gamma=c(0.5, 1), coef0=10, cost=10^(-2:2), tunecontrol=tune.control(sampling="cross", cross=3))
print(paste("Najmniejszy bd klasyfikacji dla sigmoidalnej funkcji jdrowej:", signif(svm.iris$best.performance, digits=2)), quote=FALSE)
print("Parametry tego modelu SVM:", quote=FALSE)
print(svm.iris$best.parameters)
#Jeli zbudowano model lepszy od najlepszego z wczeniej rozwaonych to zapamitujemy go:
if (svm.iris$best.performance < min.err) {najl.model <- svm.iris$best.model; min.err <- svm.iris$best.performance}
#Najlepszy model SVM z wykorzystaniem liniowej funkcji jdrowej:
svm.iris <- tune.svm(klasa ~ ., data=iris149, kernel = "linear", cost=10^(-2:2), tunecontrol=tune.control(sampling="cross", cross=3))
print(paste("Najmniejszy bd klasyfikacji dla liniowej funkcji jdrowej:", signif(svm.iris$best.performance, digits=2)), quote=FALSE)
print("Parametry tego modelu SVM:", quote=FALSE)
print(svm.iris$best.parameters)
#Jeli zbudowano model lepszy od najlepszego z wczeniej rozwaonych to zapamitujemy go
if (svm.iris$best.performance < min.err) {najl.model <- svm.iris$best.model; min.err <- svm.iris$best.performance}
#Badanie przynalenoci do klasy wylosowanej wczeniej obserwacji
nowy.bez.klasy <- subset(nowy, select=-klasa)
#Najlepsza kombinacja parametrw i odpowiadajcy jej model
klasa.nowy <- predict(najl.model, nowy.bez.klasy)
print(paste("Najlepszy z modeli SVM sklasyfikowa wybran obserwacj jako:", klasa.nowy), quote=FALSE)
print("Parametry najlepszego z wyznaczonych modeli:", quote=FALSE)
print(summary(najl.model))
detach(iris)