#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Micha Trzsiok     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

options(OutDec=",")
print("Prawdopodobiestwo, e w serii 10 dowiadcze Bernoulliego otrzymamy dokadnie 6 sukcesw, jeli prawdopodobiestwo sukcesu w pojedynczym dowiadczeniu p=0,5:",quote=FALSE)
dbinom(x=6,size=10,prob=0.5)
print("Prawdopodobiestwo, e w serii 100 dowiadcze odnotujemy nie wicej ni 45 sukcesw, jeli prawdopodobiestwo sukcesu w pojedynczym dowiadczeniu p=0,6:",quote=FALSE)
pbinom(q=45,size=100,prob=0.6)
print("Cig siedmiu liczb losowych - liczby sukcesw jakie mona otrzyma realizujc siedem razy seri dwudziestu dowiadcze Bernoulliego z zaoonym prawdopodobiestwem sukcesu w pojedynczym dowiadczeniu p=0,5:",quote=FALSE)
rbinom(n=7,size=20,prob=0.5)
print("Kwantyl rzdu 0,3 dla rozkadu dwumianowego liczby sukcesw w serii dwudziestu dowiadcze Bernoulliego z zaoonym prawdopodobiestwem sukcesu w pojedynczym dowiadczeniu 0,5:",quote=FALSE)
print("Uwaga! Tu pewna kolizja oznacze. W funkcji 'qbinom' liter 'p' oznaczono argument bdcy rzdem kwantyla. W tym punkcie ksiki przez 'p' oznaczono prawdopodobiestwo sukcesu w pojedynczym dowiadczeniu.",quote=FALSE)
qbinom(p=0.3,size=20,prob=0.5)
print("Przykadowe wykresy funkcji prawdopodobiestwa oraz dystrybuanty zmiennej o rozkadzie dwumianowym:",quote=FALSE)
par(mfrow=c(2,1)) #dwa wykresy w jednym oknie graficznym
k<-1:20
plot(k,dbinom(k,20,0.4),type="h",lwd=3,ylab="P(X=k)",main="Funkcja prawdopodobiestwa dla rozkadu dwumianowego B(n=20; p=0,4)",cex.main=1.0,font.main=1,font.lab=3,las=1)
plot(k,pbinom(k,20,0.4),type="s",ylab="F(k)",main="Dystrybuanta rozkadu dwumianowego B(n=20; p=0,4)",cex.main=1.0,font.main=1,font.lab=3,las=1)