#Antes de nada, nos situamos en el directorio de trabajo
setwd("D:/Asignaturas/Curso R")
#Cargamos los datos que vamos a utilizar
load("JaenIndicadores.rda")
#Cmo se llaman?
objects()
#Se llaman Datos. Y cules son sus variables?
names(Datos)


###############CLCULO DE MEDIDAS DE POSICIN, DISPERSIN Y FORMA
#Media
mean(Datos$agua.hab)#Fijaros que da NA porque hay datos que faltan. Hay que decirle que los elimine para las cuentas
mean(Datos$agua.hab,na.rm=TRUE)
mean(Datos$elec.hab,na.rm=TRUE)
mean(Datos$res.hab,na.rm=TRUE)
#O bien, las tres medias juntas
mean(Datos[,c("agua.hab","elec.hab","res.hab")],na.rm=TRUE)#Todas las filas y las tres columnas que queremos

#Desviacin tpica
sd(Datos$agua.hab,na.rm=TRUE)
sd(Datos$elec.hab,na.rm=TRUE)
sd(Datos$res.hab,na.rm=TRUE)
#O bien,
sd(Datos[,c("agua.hab","elec.hab","res.hab")],na.rm=TRUE)

#Coeficientes de variacin. Slo es el cociente!
sd(Datos[,c("agua.hab","elec.hab","res.hab")],na.rm=TRUE)/mean(Datos[,c("agua.hab","elec.hab","res.hab")],na.rm=TRUE)

#Cuantiles. Por ejemplo, percentil 5 y percentil 95
quantile(Datos$agua.hab,probs=c(0.05,0.95),na.rm=TRUE)
quantile(Datos$elec.hab,probs=c(0.05,0.95),na.rm=TRUE)
quantile(Datos$res.hab,probs=c(0.05,0.95),na.rm=TRUE)

#Coeficiente de asimetra. 
library(e1071)
skewness(Datos$agua.hab,na.rm=TRUE)
skewness(Datos$elec.hab,na.rm=TRUE)
skewness(Datos$res.hab,na.rm=TRUE)

#Anlisis por grupos dados por la variable Tipo
levels(Datos$Tipo)#Es la variable relativa al tamao del municipio
#A la funcin tapply tenemos que decirle:
#1. Qu datos manejamos?
#2. Qu factor es el que determina los grupos?
#3. Qu funcin queremos aplicar?
#4. Informacin adicional necesaria para la funcin
tapply(Datos$agua.hab,Datos$Tipo,mean, na.rm=TRUE)
tapply(Datos$agua.hab,Datos$Tipo,sd, na.rm=TRUE)  
tapply(Datos$agua.hab,Datos$Tipo,quantile,probs=c(0.05,0.95),na.rm=TRUE) 

tapply(Datos$elec.hab,Datos$Tipo,mean, na.rm=TRUE)
tapply(Datos$elec.hab,Datos$Tipo,sd, na.rm=TRUE)  
tapply(Datos$elec.hab,Datos$Tipo,quantile,probs=c(0.05,0.95),na.rm=TRUE) 

tapply(Datos$res.hab,Datos$Tipo,mean, na.rm=TRUE)
tapply(Datos$res.hab,Datos$Tipo,sd, na.rm=TRUE)  
tapply(Datos$res.hab,Datos$Tipo,quantile,probs=c(0.05,0.95),na.rm=TRUE)

###############DISTRIBUCIN DE FRECUENCIAS
Tabla <- table(Datos$Tipo)               
Tabla # Frecuencias absolutas            
Tabla.rel<-prop.table(Tabla)
Tabla.rel# Frecuencias relativas

################GRFICOS ASOCIADOS A UNA DISTRIBUCIN DE FRECUENCIAS

#Diagrama de barras para la variable Tipo
#Lo vamos a hacer con las frecuencias absolutas
barras.tipo<-barplot(Tabla,col=rainbow(3),xlab="Municipios segn su Tipo",ylab="Frecuencias absolutas") #Esto dibuja el diagrama de barras asociado a Tabla
#Ahora quiero aadir las frecuencias al grfico:
#1. En el eje X me sito en el mismo sitio que estn las columnas de diagrama
#2. En el eje Y me sito un poco por encima de las frecuencias que me da Tabla
#3. Justo ah quiero que escriba las frecuencias que me da Tabla
text(barras.tipo,Tabla + 1,labels=Tabla, xpd = TRUE) # xpd = TRUE es para que "estire" un poco el grfico y quepa todo 
title(main = "Distribucin de frecuencias de la variable Tipo", font.main = 4)

#Diagrama de sectores para la variable Residuos.slidos.urbanos..Destino
#Ahora lo vamos a hacer con las frecuencias relativas expresadas en porcentajes
tabla.destino<-prop.table(table(Datos$Residuos.slidos.urbanos..Destino))
tabla.destino<-round(100*tabla.destino,2)#En porcentaje y redondeando
sectores.destino<-pie(tabla.destino,labels=paste(names(tabla.destino),tabla.destino,"%"),main="Distribucin de porcentajes de la variable Destino de los residuos slidos urbanos")

#Histograma de agua.hab
hist(Datos$agua.hab, breaks = 10, freq = TRUE, main = "Histograma del consumo de agua por habitante ",xlab="",ylab="Frecuencias")

#Diagrama de barras de una variable discreta mediante un histograma
#Tomemos estos datos
datos<-rpois(100,2.5)
#Los puntos de corte del histograma fuerzan a que contemos los 0, los 1, ...
cortes<-(min(datos)-0.5):(max(datos)+0.5)
#El histograma:
hist(datos,breaks=cortes,freq=TRUE,labels=TRUE,ylab="Frecuencias",main="Diagrama de barras de unos datos discretos")

#Diagrama de caja de elec.hab
boxplot(Datos$elec.hab,main="Diagrama de caja para el consumo elctrico por habitante",ylab="Consumo por habitante")
identify(rep(1, length(Datos$elec.hab)),Datos$elec.hab, rownames(Datos))
#O bien
identify(rep(1, length(Datos$elec.hab)),Datos$elec.hab, Datos$Municipio)