Object subclass: #SimpleServer
	instanceVariableNames: 'isRunning stateLock connectionSocket portNumber'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Challenge4-ServerSide'!

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 10:00'!
handleConnections
	| interactionSocket interactionStream |
	interactionSocket := self connectionSocket 
		waitForAcceptFor: 30  
		ifTimedOut: [^self].
	interactionStream := SocketStream on: interactionSocket.
	[self interactThenClose: interactionStream] fork
! !

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 10:09'!
interactThenClose: aSocketStream
	[
		self interactThrough: aSocketStream
	] ensure: [
		aSocketStream close.
	] 
! !

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 10:00'!
interactThrough: aSocketStream
	self subclassResponsibility! !

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 09:47'!
serve
	self connectionSocket: Socket newTCP.
	[
		self connectionSocket listenOn: self portNumber backlogSize: 10.
		[self isRunning] whileTrue: [self handleConnections].
	] ensure: [
		self connectionSocket closeAndDestroy].
	! !

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 10:05'!
start
	stateLock
		critical: [ 
			self isRunning
				ifTrue: [ ^ self ].
			self isRunning: true ].
	[self serve] fork! !

!SimpleServer methodsFor: 'running' stamp: 'NouryBouraqadi 2/18/2011 09:42'!
stop
	self isRunning: false! !


!SimpleServer methodsFor: 'initialize-release' stamp: 'NouryBouraqadi 2/18/2011 09:42'!
initialize 
	super initialize.
	stateLock := Mutex new.
	self isRunning: false  ! !


!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:47'!
connectionSocket
	^ connectionSocket! !

!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:47'!
connectionSocket: anObject
	connectionSocket := anObject! !

!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:43'!
isRunning
	stateLock critical: [^isRunning]! !

!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:42'!
isRunning: aBoolean
	stateLock critical: [isRunning := aBoolean]! !

!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:56'!
portNumber
	^ portNumber! !

!SimpleServer methodsFor: 'accessing' stamp: 'NouryBouraqadi 2/18/2011 09:57'!
portNumber: anInteger
	portNumber := anInteger! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SimpleServer class
	instanceVariableNames: ''!

!SimpleServer class methodsFor: 'instance creation' stamp: 'NouryBouraqadi 2/18/2011 09:58'!
onPortNumber: anInteger
	^self new
		portNumber: anInteger;
		yourself  ! !


SimpleServer subclass: #Dispatcher
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Challenge4-ServerSide'!
!Dispatcher commentStamp: 'NouryBouraqadi 3/9/2011 09:47' prior: 0!
"Code for the talk on networking @ Deep Into Smalltalk Spring School 2011"
"Slides and other materials online http://car.mines-douai.fr/noury/docs"
"Noury Bouraqadi march 2011"

Dispatcher is a simple TCP server that interacts with a remote client through a socket stream. The client is a remote proxy that captures messages and serialize them before sending to the dispatcher through a socket stream. The dispatcher deserialises received bytes into messages and sends them to the local Transcript.

To test dispatcher evaluate the following in a workspace.

"Create and start the dispatching server"
server := Dispatcher onPortNumber: 5432.
server start.

"Answers true if the server is started properly"
server isRunning.

"Stops the server"
server stop.

!


!Dispatcher methodsFor: 'handling connections' stamp: 'NouryBouraqadi 3/8/2011 17:09'!
interactThrough: aSocketStream
	self dispatch: aSocketStream nextLine! !


!Dispatcher methodsFor: 'dispatching' stamp: 'NouryBouraqadi 3/8/2011 18:52'!
dispatch: messageBytes
	| message |
	message := ReferenceStream unStream: messageBytes.
	message sendTo: Transcript 	  ! !
