ProtoObject subclass: #Proxy
	instanceVariableNames: 'socketStream portNumber'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Challenge4-ClientSide'!
!Proxy commentStamp: 'NouryBouraqadi 3/9/2011 09:34' prior: 0!
"Code for the talk on networking @ Deep Into Smalltalk Spring School 2011"
"Slides and other materials online http://car.mines-douai.fr/noury/docs"
"Noury Bouraqadi march 2011"

A Proxy is a place holder of a remote object. I capture and forward messages to the other at the other side.
The "other side" is a server which host and IP address is hardwired.
You can make it parametrizable.
 
I create a new socket stream on every message send which is closed after the message send. This is because the simple server does close the connection.

For the following exampe, we make the assumption that the remote server is started on port 5432 and dispatches all messages the remote Transcript, you can evaluate the following code in a workspace. 
proxy := Proxy newOnPort: 5432.
proxy cr; show: 'Hello from the other side'.!


!Proxy methodsFor: 'accessing' stamp: 'NouryBouraqadi 3/9/2011 09:37'!
xxxPortNumber: newPortNumber
	portNumber := newPortNumber! !


!Proxy methodsFor: 'controlling messages' stamp: 'NouryBouraqadi 3/9/2011 09:42'!
doesNotUnderstand: aMessage
	"Message answer is not handled!!"
	| messageBytes |
	aMessage lookupClass: nil.
	messageBytes := ReferenceStream streamedRepresentationOf: aMessage.
	socketStream := SocketStream 
		openConnectionToHostNamed: 'localhost' 
		port: portNumber.
	socketStream isConnected ifFalse: [^nil].
	[socketStream sendCommand: messageBytes] ensure: [socketStream close].
	  ! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Proxy class
	instanceVariableNames: ''!

!Proxy class methodsFor: 'instance creation' stamp: 'NouryBouraqadi 3/9/2011 09:40'!
newOnPort: portNumber
	| newProxy |
	"Do NOT use yourself since a proxy does NOT understand it!!"
	newProxy := self new.
	newProxy xxxPortNumber: portNumber.
	^newProxy  ! !
