smalltalk.parser = (function(){
  /* Generated by PEG.js 0.6.2 (http://pegjs.majda.cz/). */
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successfull,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    parse: function(input, startRule) {
      var parseFunctions = {
        "assignment": parse_assignment,
        "binaryMessage": parse_binaryMessage,
        "binaryPattern": parse_binaryPattern,
        "binarySelector": parse_binarySelector,
        "binarySend": parse_binarySend,
        "binaryTail": parse_binaryTail,
        "block": parse_block,
        "blockParamList": parse_blockParamList,
        "cascade": parse_cascade,
        "className": parse_className,
        "classReference": parse_classReference,
        "comments": parse_comments,
        "dynamicArray": parse_dynamicArray,
        "dynamicDictionary": parse_dynamicDictionary,
        "expression": parse_expression,
        "expressionList": parse_expressionList,
        "expressions": parse_expressions,
        "float": parse_float,
        "identifier": parse_identifier,
        "integer": parse_integer,
        "jsStatement": parse_jsStatement,
        "keyword": parse_keyword,
        "keywordMessage": parse_keywordMessage,
        "keywordPair": parse_keywordPair,
        "keywordPattern": parse_keywordPattern,
        "keywordSend": parse_keywordSend,
        "literal": parse_literal,
        "literalArray": parse_literalArray,
        "message": parse_message,
        "method": parse_method,
        "number": parse_number,
        "operand": parse_operand,
        "pseudoVariable": parse_pseudoVariable,
        "reference": parse_reference,
        "ret": parse_ret,
        "separator": parse_separator,
        "sequence": parse_sequence,
        "statements": parse_statements,
        "string": parse_string,
        "subexpression": parse_subexpression,
        "symbol": parse_symbol,
        "temps": parse_temps,
        "unaryMessage": parse_unaryMessage,
        "unaryPattern": parse_unaryPattern,
        "unarySend": parse_unarySend,
        "unaryTail": parse_unaryTail,
        "varIdentifier": parse_varIdentifier,
        "variable": parse_variable,
        "ws": parse_ws
      };
      
      if (startRule !== undefined) {
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Invalid rule name: " + quote(startRule) + ".");
        }
      } else {
        startRule = "method";
      }
      
      var pos = 0;
      var reportMatchFailures = true;
      var rightmostMatchFailuresPos = 0;
      var rightmostMatchFailuresExpected = [];
      var cache = {};
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        
        if (charCode <= 0xFF) {
          var escapeChar = 'x';
          var length = 2;
        } else {
          var escapeChar = 'u';
          var length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function quote(s) {
        /*
         * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
         * string literal except for the closing quote character, backslash,
         * carriage return, line separator, paragraph separator, and line feed.
         * Any character may appear in the form of an escape sequence.
         */
        return '"' + s
          .replace(/\\/g, '\\\\')            // backslash
          .replace(/"/g, '\\"')              // closing quote character
          .replace(/\r/g, '\\r')             // carriage return
          .replace(/\n/g, '\\n')             // line feed
          .replace(/[\x80-\uFFFF]/g, escape) // non-ASCII characters
          + '"';
      }
      
      function matchFailed(failure) {
        if (pos < rightmostMatchFailuresPos) {
          return;
        }
        
        if (pos > rightmostMatchFailuresPos) {
          rightmostMatchFailuresPos = pos;
          rightmostMatchFailuresExpected = [];
        }
        
        rightmostMatchFailuresExpected.push(failure);
      }
      
      function parse_separator() {
        var cacheKey = 'separator@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        if (input.substr(pos).match(/^[ 	\xA0\uFEFF\n\r\u2028\u2029]/) !== null) {
          var result1 = input.charAt(pos);
          pos++;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("[ 	\\xA0\\uFEFF\\n\\r\\u2028\\u2029]");
          }
        }
        if (result1 !== null) {
          var result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (input.substr(pos).match(/^[ 	\xA0\uFEFF\n\r\u2028\u2029]/) !== null) {
              var result1 = input.charAt(pos);
              pos++;
            } else {
              var result1 = null;
              if (reportMatchFailures) {
                matchFailed("[ 	\\xA0\\uFEFF\\n\\r\\u2028\\u2029]");
              }
            }
          }
        } else {
          var result0 = null;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_comments() {
        var cacheKey = 'comments@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        if (input.substr(pos).match(/^["]/) !== null) {
          var result2 = input.charAt(pos);
          pos++;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("[\"]");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^"]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[^\"]");
            }
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^"]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[^\"]");
              }
            }
          }
          if (result3 !== null) {
            if (input.substr(pos).match(/^["]/) !== null) {
              var result4 = input.charAt(pos);
              pos++;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("[\"]");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        if (result1 !== null) {
          var result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            var savedPos0 = pos;
            if (input.substr(pos).match(/^["]/) !== null) {
              var result2 = input.charAt(pos);
              pos++;
            } else {
              var result2 = null;
              if (reportMatchFailures) {
                matchFailed("[\"]");
              }
            }
            if (result2 !== null) {
              var result3 = [];
              if (input.substr(pos).match(/^[^"]/) !== null) {
                var result5 = input.charAt(pos);
                pos++;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("[^\"]");
                }
              }
              while (result5 !== null) {
                result3.push(result5);
                if (input.substr(pos).match(/^[^"]/) !== null) {
                  var result5 = input.charAt(pos);
                  pos++;
                } else {
                  var result5 = null;
                  if (reportMatchFailures) {
                    matchFailed("[^\"]");
                  }
                }
              }
              if (result3 !== null) {
                if (input.substr(pos).match(/^["]/) !== null) {
                  var result4 = input.charAt(pos);
                  pos++;
                } else {
                  var result4 = null;
                  if (reportMatchFailures) {
                    matchFailed("[\"]");
                  }
                }
                if (result4 !== null) {
                  var result1 = [result2, result3, result4];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          }
        } else {
          var result0 = null;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ws() {
        var cacheKey = 'ws@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result0 = [];
        var result3 = parse_separator();
        if (result3 !== null) {
          var result1 = result3;
        } else {
          var result2 = parse_comments();
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        while (result1 !== null) {
          result0.push(result1);
          var result3 = parse_separator();
          if (result3 !== null) {
            var result1 = result3;
          } else {
            var result2 = parse_comments();
            if (result2 !== null) {
              var result1 = result2;
            } else {
              var result1 = null;;
            };
          }
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_identifier() {
        var cacheKey = 'identifier@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[a-zA-Z]/) !== null) {
          var result3 = input.charAt(pos);
          pos++;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("[a-zA-Z]");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[a-zA-Z0-9]");
            }
          }
          while (result5 !== null) {
            result4.push(result5);
            if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[a-zA-Z0-9]");
              }
            }
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(first, others) {return first + others.join("")})(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_varIdentifier() {
        var cacheKey = 'varIdentifier@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[a-z]/) !== null) {
          var result3 = input.charAt(pos);
          pos++;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("[a-z]");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[a-zA-Z0-9]");
            }
          }
          while (result5 !== null) {
            result4.push(result5);
            if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[a-zA-Z0-9]");
              }
            }
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(first, others) {return first + others.join("")})(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_keyword() {
        var cacheKey = 'keyword@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_identifier();
        if (result3 !== null) {
          if (input.substr(pos).match(/^[:]/) !== null) {
            var result4 = input.charAt(pos);
            pos++;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("[:]");
            }
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(first, last) {return first + last})(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_className() {
        var cacheKey = 'className@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[A-Z]/) !== null) {
          var result3 = input.charAt(pos);
          pos++;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("[A-Z]");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[a-zA-Z0-9]");
            }
          }
          while (result5 !== null) {
            result4.push(result5);
            if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[a-zA-Z0-9]");
              }
            }
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(first, others) {return first + others.join("")})(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_string() {
        var cacheKey = 'string@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[']/) !== null) {
          var result3 = input.charAt(pos);
          pos++;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("[']");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          var savedPos2 = pos;
          if (input.substr(pos, 2) === "''") {
            var result9 = "''";
            pos += 2;
          } else {
            var result9 = null;
            if (reportMatchFailures) {
              matchFailed("\"''\"");
            }
          }
          var result10 = result9 !== null
            ? (function() {return "'"})()
            : null;
          if (result10 !== null) {
            var result8 = result10;
          } else {
            var result8 = null;
            pos = savedPos2;
          }
          if (result8 !== null) {
            var result6 = result8;
          } else {
            if (input.substr(pos).match(/^[^']/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^']");
              }
            }
            if (result7 !== null) {
              var result6 = result7;
            } else {
              var result6 = null;;
            };
          }
          while (result6 !== null) {
            result4.push(result6);
            var savedPos2 = pos;
            if (input.substr(pos, 2) === "''") {
              var result9 = "''";
              pos += 2;
            } else {
              var result9 = null;
              if (reportMatchFailures) {
                matchFailed("\"''\"");
              }
            }
            var result10 = result9 !== null
              ? (function() {return "'"})()
              : null;
            if (result10 !== null) {
              var result8 = result10;
            } else {
              var result8 = null;
              pos = savedPos2;
            }
            if (result8 !== null) {
              var result6 = result8;
            } else {
              if (input.substr(pos).match(/^[^']/) !== null) {
                var result7 = input.charAt(pos);
                pos++;
              } else {
                var result7 = null;
                if (reportMatchFailures) {
                  matchFailed("[^']");
                }
              }
              if (result7 !== null) {
                var result6 = result7;
              } else {
                var result6 = null;;
              };
            }
          }
          if (result4 !== null) {
            if (input.substr(pos).match(/^[']/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[']");
              }
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(val) {
                         	   return smalltalk.ValueNode._new()
                         	   	._value_(val.join("").replace(/\"/ig, '"'))
          	         })(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_symbol() {
        var cacheKey = 'symbol@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "#") {
          var result3 = "#";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"#\"");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          var savedPos3 = pos;
          if (input.substr(pos).match(/^[a-zA-Z0-9:]/) !== null) {
            var result12 = input.charAt(pos);
            pos++;
          } else {
            var result12 = null;
            if (reportMatchFailures) {
              matchFailed("[a-zA-Z0-9:]");
            }
          }
          if (result12 !== null) {
            var result10 = [];
            while (result12 !== null) {
              result10.push(result12);
              if (input.substr(pos).match(/^[a-zA-Z0-9:]/) !== null) {
                var result12 = input.charAt(pos);
                pos++;
              } else {
                var result12 = null;
                if (reportMatchFailures) {
                  matchFailed("[a-zA-Z0-9:]");
                }
              }
            }
          } else {
            var result10 = null;
          }
          var result11 = result10 !== null
            ? (function(digits) {return digits.join("")})(result10)
            : null;
          if (result11 !== null) {
            var result9 = result11;
          } else {
            var result9 = null;
            pos = savedPos3;
          }
          if (result9 !== null) {
            var result5 = result9;
          } else {
            var savedPos2 = pos;
            var result7 = parse_string();
            var result8 = result7 !== null
              ? (function(node) {return node._value()})(result7)
              : null;
            if (result8 !== null) {
              var result6 = result8;
            } else {
              var result6 = null;
              pos = savedPos2;
            }
            if (result6 !== null) {
              var result5 = result6;
            } else {
              var result5 = null;;
            };
          }
          while (result5 !== null) {
            result4.push(result5);
            var savedPos3 = pos;
            if (input.substr(pos).match(/^[a-zA-Z0-9:]/) !== null) {
              var result12 = input.charAt(pos);
              pos++;
            } else {
              var result12 = null;
              if (reportMatchFailures) {
                matchFailed("[a-zA-Z0-9:]");
              }
            }
            if (result12 !== null) {
              var result10 = [];
              while (result12 !== null) {
                result10.push(result12);
                if (input.substr(pos).match(/^[a-zA-Z0-9:]/) !== null) {
                  var result12 = input.charAt(pos);
                  pos++;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("[a-zA-Z0-9:]");
                  }
                }
              }
            } else {
              var result10 = null;
            }
            var result11 = result10 !== null
              ? (function(digits) {return digits.join("")})(result10)
              : null;
            if (result11 !== null) {
              var result9 = result11;
            } else {
              var result9 = null;
              pos = savedPos3;
            }
            if (result9 !== null) {
              var result5 = result9;
            } else {
              var savedPos2 = pos;
              var result7 = parse_string();
              var result8 = result7 !== null
                ? (function(node) {return node._value()})(result7)
                : null;
              if (result8 !== null) {
                var result6 = result8;
              } else {
                var result6 = null;
                pos = savedPos2;
              }
              if (result6 !== null) {
                var result5 = result6;
              } else {
                var result5 = null;;
              };
            }
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(val) {
          		  		    return smalltalk.ValueNode._new()
                         	   		    	   ._value_(smalltalk.symbolFor(val.join("").replace(/\"/ig, '"')))
                         	 })(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_number() {
        var cacheKey = 'number@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var result4 = parse_float();
        if (result4 !== null) {
          var result1 = result4;
        } else {
          var result3 = parse_integer();
          if (result3 !== null) {
            var result1 = result3;
          } else {
            var result1 = null;;
          };
        }
        var result2 = result1 !== null
          ? (function(n) {
          		  return smalltalk.ValueNode._new()
                         	   	._value_(n)
                         	 })(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_float() {
        var cacheKey = 'float@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[\-]/) !== null) {
          var result9 = input.charAt(pos);
          pos++;
        } else {
          var result9 = null;
          if (reportMatchFailures) {
            matchFailed("[\\-]");
          }
        }
        var result3 = result9 !== null ? result9 : '';
        if (result3 !== null) {
          if (input.substr(pos).match(/^[0-9]/) !== null) {
            var result8 = input.charAt(pos);
            pos++;
          } else {
            var result8 = null;
            if (reportMatchFailures) {
              matchFailed("[0-9]");
            }
          }
          if (result8 !== null) {
            var result4 = [];
            while (result8 !== null) {
              result4.push(result8);
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result8 = input.charAt(pos);
                pos++;
              } else {
                var result8 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
            }
          } else {
            var result4 = null;
          }
          if (result4 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result5 = ".";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result5 !== null) {
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result7 = input.charAt(pos);
                pos++;
              } else {
                var result7 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
              if (result7 !== null) {
                var result6 = [];
                while (result7 !== null) {
                  result6.push(result7);
                  if (input.substr(pos).match(/^[0-9]/) !== null) {
                    var result7 = input.charAt(pos);
                    pos++;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("[0-9]");
                    }
                  }
                }
              } else {
                var result6 = null;
              }
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(neg, int, dec) {return parseFloat((neg + int.join("") + "." + dec.join("")), 10)})(result1[0], result1[1], result1[3])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_integer() {
        var cacheKey = 'integer@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[\-]/) !== null) {
          var result6 = input.charAt(pos);
          pos++;
        } else {
          var result6 = null;
          if (reportMatchFailures) {
            matchFailed("[\\-]");
          }
        }
        var result3 = result6 !== null ? result6 : '';
        if (result3 !== null) {
          if (input.substr(pos).match(/^[0-9]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[0-9]");
            }
          }
          if (result5 !== null) {
            var result4 = [];
            while (result5 !== null) {
              result4.push(result5);
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result5 = input.charAt(pos);
                pos++;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
            }
          } else {
            var result4 = null;
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(neg, digits) {return (parseInt(neg+digits.join(""), 10))})(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_literalArray() {
        var cacheKey = 'literalArray@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 2) === "#(") {
          var result3 = "#(";
          pos += 2;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"#(\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result5 = [];
            var savedPos2 = pos;
            var savedPos3 = pos;
            var result11 = parse_literal();
            if (result11 !== null) {
              var result12 = parse_ws();
              if (result12 !== null) {
                var result9 = [result11, result12];
              } else {
                var result9 = null;
                pos = savedPos3;
              }
            } else {
              var result9 = null;
              pos = savedPos3;
            }
            var result10 = result9 !== null
              ? (function(lit) {return lit._value()})(result9[0])
              : null;
            if (result10 !== null) {
              var result8 = result10;
            } else {
              var result8 = null;
              pos = savedPos2;
            }
            while (result8 !== null) {
              result5.push(result8);
              var savedPos2 = pos;
              var savedPos3 = pos;
              var result11 = parse_literal();
              if (result11 !== null) {
                var result12 = parse_ws();
                if (result12 !== null) {
                  var result9 = [result11, result12];
                } else {
                  var result9 = null;
                  pos = savedPos3;
                }
              } else {
                var result9 = null;
                pos = savedPos3;
              }
              var result10 = result9 !== null
                ? (function(lit) {return lit._value()})(result9[0])
                : null;
              if (result10 !== null) {
                var result8 = result10;
              } else {
                var result8 = null;
                pos = savedPos2;
              }
            }
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                if (input.substr(pos, 1) === ")") {
                  var result7 = ")";
                  pos += 1;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("\")\"");
                  }
                }
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(lits) {
          		  return smalltalk.ValueNode._new()
                         	   	._value_(lits)
                         	 })(result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_dynamicArray() {
        var cacheKey = 'dynamicArray@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "{") {
          var result3 = "{";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"{\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result8 = parse_expressions();
            var result5 = result8 !== null ? result8 : '';
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                if (input.substr(pos, 1) === "}") {
                  var result7 = "}";
                  pos += 1;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"}\"");
                  }
                }
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(expressions) {
          	       	  return smalltalk.DynamicArrayNode._new()
          		        ._nodes_(expressions)
          		  })(result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_dynamicDictionary() {
        var cacheKey = 'dynamicDictionary@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 2) === "#{") {
          var result3 = "#{";
          pos += 2;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"#{\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result8 = parse_expressions();
            var result5 = result8 !== null ? result8 : '';
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                if (input.substr(pos, 1) === "}") {
                  var result7 = "}";
                  pos += 1;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"}\"");
                  }
                }
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(expressions) {
          	       	  return smalltalk.DynamicDictionaryNode._new()
          		        ._nodes_(expressions)
          		  })(result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_pseudoVariable() {
        var cacheKey = 'pseudoVariable@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos3 = pos;
        if (input.substr(pos, 4) === "true") {
          var result10 = "true";
          pos += 4;
        } else {
          var result10 = null;
          if (reportMatchFailures) {
            matchFailed("\"true\"");
          }
        }
        var result11 = result10 !== null
          ? (function() {return true})()
          : null;
        if (result11 !== null) {
          var result9 = result11;
        } else {
          var result9 = null;
          pos = savedPos3;
        }
        if (result9 !== null) {
          var result1 = result9;
        } else {
          var savedPos2 = pos;
          if (input.substr(pos, 5) === "false") {
            var result7 = "false";
            pos += 5;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("\"false\"");
            }
          }
          var result8 = result7 !== null
            ? (function() {return false})()
            : null;
          if (result8 !== null) {
            var result6 = result8;
          } else {
            var result6 = null;
            pos = savedPos2;
          }
          if (result6 !== null) {
            var result1 = result6;
          } else {
            var savedPos1 = pos;
            if (input.substr(pos, 3) === "nil") {
              var result4 = "nil";
              pos += 3;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"nil\"");
              }
            }
            var result5 = result4 !== null
              ? (function() {return nil})()
              : null;
            if (result5 !== null) {
              var result3 = result5;
            } else {
              var result3 = null;
              pos = savedPos1;
            }
            if (result3 !== null) {
              var result1 = result3;
            } else {
              var result1 = null;;
            };
          };
        }
        var result2 = result1 !== null
          ? (function(val) {
          			return smalltalk.ValueNode._new()._value_(val)
          		    })(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_literal() {
        var cacheKey = 'literal@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result8 = parse_pseudoVariable();
        if (result8 !== null) {
          var result0 = result8;
        } else {
          var result7 = parse_number();
          if (result7 !== null) {
            var result0 = result7;
          } else {
            var result6 = parse_literalArray();
            if (result6 !== null) {
              var result0 = result6;
            } else {
              var result5 = parse_dynamicDictionary();
              if (result5 !== null) {
                var result0 = result5;
              } else {
                var result4 = parse_dynamicArray();
                if (result4 !== null) {
                  var result0 = result4;
                } else {
                  var result3 = parse_string();
                  if (result3 !== null) {
                    var result0 = result3;
                  } else {
                    var result2 = parse_symbol();
                    if (result2 !== null) {
                      var result0 = result2;
                    } else {
                      var result1 = parse_block();
                      if (result1 !== null) {
                        var result0 = result1;
                      } else {
                        var result0 = null;;
                      };
                    };
                  };
                };
              };
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_variable() {
        var cacheKey = 'variable@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var result1 = parse_varIdentifier();
        var result2 = result1 !== null
          ? (function(identifier) {
          		  return smalltalk.VariableNode._new()
          			._value_(identifier)
          		  })(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_classReference() {
        var cacheKey = 'classReference@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var result1 = parse_className();
        var result2 = result1 !== null
          ? (function(className) {
          		  return smalltalk.ClassReferenceNode._new()
          		  	._value_(className)
          		  })(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_reference() {
        var cacheKey = 'reference@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result2 = parse_variable();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_classReference();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_keywordPair() {
        var cacheKey = 'keywordPair@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_keyword();
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result5 = parse_binarySend();
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(key, arg) {return {key:key, arg: arg}})(result1[0], result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_binarySelector() {
        var cacheKey = 'binarySelector@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        if (input.substr(pos).match(/^[\\+*\/=><,@%~|&\-]/) !== null) {
          var result3 = input.charAt(pos);
          pos++;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("[\\\\+*\\/=><,@%~|&\\-]");
          }
        }
        if (result3 !== null) {
          var result1 = [];
          while (result3 !== null) {
            result1.push(result3);
            if (input.substr(pos).match(/^[\\+*\/=><,@%~|&\-]/) !== null) {
              var result3 = input.charAt(pos);
              pos++;
            } else {
              var result3 = null;
              if (reportMatchFailures) {
                matchFailed("[\\\\+*\\/=><,@%~|&\\-]");
              }
            }
          }
        } else {
          var result1 = null;
        }
        var result2 = result1 !== null
          ? (function(bin) {return bin.join("").replace(/\\/g, '\\\\')})(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_keywordPattern() {
        var cacheKey = 'keywordPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var savedPos2 = pos;
        var result6 = parse_ws();
        if (result6 !== null) {
          var result7 = parse_keyword();
          if (result7 !== null) {
            var result8 = parse_ws();
            if (result8 !== null) {
              var result9 = parse_identifier();
              if (result9 !== null) {
                var result4 = [result6, result7, result8, result9];
              } else {
                var result4 = null;
                pos = savedPos2;
              }
            } else {
              var result4 = null;
              pos = savedPos2;
            }
          } else {
            var result4 = null;
            pos = savedPos2;
          }
        } else {
          var result4 = null;
          pos = savedPos2;
        }
        var result5 = result4 !== null
          ? (function(key, arg) {return {key:key, arg: arg}})(result4[1], result4[3])
          : null;
        if (result5 !== null) {
          var result3 = result5;
        } else {
          var result3 = null;
          pos = savedPos1;
        }
        if (result3 !== null) {
          var result1 = [];
          while (result3 !== null) {
            result1.push(result3);
            var savedPos1 = pos;
            var savedPos2 = pos;
            var result6 = parse_ws();
            if (result6 !== null) {
              var result7 = parse_keyword();
              if (result7 !== null) {
                var result8 = parse_ws();
                if (result8 !== null) {
                  var result9 = parse_identifier();
                  if (result9 !== null) {
                    var result4 = [result6, result7, result8, result9];
                  } else {
                    var result4 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result4 = null;
                  pos = savedPos2;
                }
              } else {
                var result4 = null;
                pos = savedPos2;
              }
            } else {
              var result4 = null;
              pos = savedPos2;
            }
            var result5 = result4 !== null
              ? (function(key, arg) {return {key:key, arg: arg}})(result4[1], result4[3])
              : null;
            if (result5 !== null) {
              var result3 = result5;
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          }
        } else {
          var result1 = null;
        }
        var result2 = result1 !== null
          ? (function(pairs) {
          	             var keywords = [];
                               var params = [];
                               for(var i=0;i<pairs.length;i++){
                                   keywords.push(pairs[i].key);
                               }
                               for(var i=0;i<pairs.length;i++){
                                   params.push(pairs[i].arg);
                               }
          		     return [keywords.join(""), params]
          	         })(result1)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_binaryPattern() {
        var cacheKey = 'binaryPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result4 = parse_binarySelector();
          if (result4 !== null) {
            var result5 = parse_ws();
            if (result5 !== null) {
              var result6 = parse_identifier();
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(selector, arg) {return [selector, [arg]]})(result1[1], result1[3])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_unaryPattern() {
        var cacheKey = 'unaryPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result4 = parse_identifier();
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(selector) {return [selector, []]})(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_expression() {
        var cacheKey = 'expression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result5 = parse_assignment();
        if (result5 !== null) {
          var result0 = result5;
        } else {
          var result4 = parse_cascade();
          if (result4 !== null) {
            var result0 = result4;
          } else {
            var result3 = parse_keywordSend();
            if (result3 !== null) {
              var result0 = result3;
            } else {
              var result2 = parse_binarySend();
              if (result2 !== null) {
                var result0 = result2;
              } else {
                var result1 = parse_jsStatement();
                if (result1 !== null) {
                  var result0 = result1;
                } else {
                  var result0 = null;;
                };
              };
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_expressionList() {
        var cacheKey = 'expressionList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          if (input.substr(pos, 1) === ".") {
            var result4 = ".";
            pos += 1;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("\".\"");
            }
          }
          if (result4 !== null) {
            var result5 = parse_ws();
            if (result5 !== null) {
              var result6 = parse_expression();
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(expression) {return expression})(result1[3])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_expressions() {
        var cacheKey = 'expressions@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_expression();
        if (result3 !== null) {
          var result4 = [];
          var result5 = parse_expressionList();
          while (result5 !== null) {
            result4.push(result5);
            var result5 = parse_expressionList();
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(first, others) {
          	       	     var result = [first];
          		     for(var i=0;i<others.length;i++) {
          		 	 result.push(others[i]);
          		     }
          		     return result;
          	       })(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_assignment() {
        var cacheKey = 'assignment@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_variable();
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            if (input.substr(pos, 2) === ":=") {
              var result5 = ":=";
              pos += 2;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\":=\"");
              }
            }
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                var result7 = parse_expression();
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(variable, expression) {
          	       	     return smalltalk.AssignmentNode._new()
          	       	     	._left_(variable)
          	       	     	._right_(expression)
          		 })(result1[0], result1[4])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ret() {
        var cacheKey = 'ret@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "^") {
          var result3 = "^";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"^\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result5 = parse_expression();
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                if (input.substr(pos, 1) === ".") {
                  var result8 = ".";
                  pos += 1;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("\".\"");
                  }
                }
                var result7 = result8 !== null ? result8 : '';
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(expression) {
          	       	     return smalltalk.ReturnNode._new()
          	       	     	._nodes_([expression])
          	       })(result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_temps() {
        var cacheKey = 'temps@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "|") {
          var result3 = "|";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"|\"");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          var savedPos2 = pos;
          var savedPos3 = pos;
          var result9 = parse_ws();
          if (result9 !== null) {
            var result10 = parse_identifier();
            if (result10 !== null) {
              var result11 = parse_ws();
              if (result11 !== null) {
                var result7 = [result9, result10, result11];
              } else {
                var result7 = null;
                pos = savedPos3;
              }
            } else {
              var result7 = null;
              pos = savedPos3;
            }
          } else {
            var result7 = null;
            pos = savedPos3;
          }
          var result8 = result7 !== null
            ? (function(variable) {return variable})(result7[1])
            : null;
          if (result8 !== null) {
            var result6 = result8;
          } else {
            var result6 = null;
            pos = savedPos2;
          }
          while (result6 !== null) {
            result4.push(result6);
            var savedPos2 = pos;
            var savedPos3 = pos;
            var result9 = parse_ws();
            if (result9 !== null) {
              var result10 = parse_identifier();
              if (result10 !== null) {
                var result11 = parse_ws();
                if (result11 !== null) {
                  var result7 = [result9, result10, result11];
                } else {
                  var result7 = null;
                  pos = savedPos3;
                }
              } else {
                var result7 = null;
                pos = savedPos3;
              }
            } else {
              var result7 = null;
              pos = savedPos3;
            }
            var result8 = result7 !== null
              ? (function(variable) {return variable})(result7[1])
              : null;
            if (result8 !== null) {
              var result6 = result8;
            } else {
              var result6 = null;
              pos = savedPos2;
            }
          }
          if (result4 !== null) {
            if (input.substr(pos, 1) === "|") {
              var result5 = "|";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\"|\"");
              }
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(vars) {return vars})(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_blockParamList() {
        var cacheKey = 'blockParamList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var savedPos2 = pos;
        var savedPos3 = pos;
        var result9 = parse_ws();
        if (result9 !== null) {
          if (input.substr(pos, 1) === ":") {
            var result10 = ":";
            pos += 1;
          } else {
            var result10 = null;
            if (reportMatchFailures) {
              matchFailed("\":\"");
            }
          }
          if (result10 !== null) {
            var result11 = parse_ws();
            if (result11 !== null) {
              var result12 = parse_identifier();
              if (result12 !== null) {
                var result7 = [result9, result10, result11, result12];
              } else {
                var result7 = null;
                pos = savedPos3;
              }
            } else {
              var result7 = null;
              pos = savedPos3;
            }
          } else {
            var result7 = null;
            pos = savedPos3;
          }
        } else {
          var result7 = null;
          pos = savedPos3;
        }
        var result8 = result7 !== null
          ? (function(param) {return param})(result7[3])
          : null;
        if (result8 !== null) {
          var result6 = result8;
        } else {
          var result6 = null;
          pos = savedPos2;
        }
        if (result6 !== null) {
          var result3 = [];
          while (result6 !== null) {
            result3.push(result6);
            var savedPos2 = pos;
            var savedPos3 = pos;
            var result9 = parse_ws();
            if (result9 !== null) {
              if (input.substr(pos, 1) === ":") {
                var result10 = ":";
                pos += 1;
              } else {
                var result10 = null;
                if (reportMatchFailures) {
                  matchFailed("\":\"");
                }
              }
              if (result10 !== null) {
                var result11 = parse_ws();
                if (result11 !== null) {
                  var result12 = parse_identifier();
                  if (result12 !== null) {
                    var result7 = [result9, result10, result11, result12];
                  } else {
                    var result7 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos3;
                }
              } else {
                var result7 = null;
                pos = savedPos3;
              }
            } else {
              var result7 = null;
              pos = savedPos3;
            }
            var result8 = result7 !== null
              ? (function(param) {return param})(result7[3])
              : null;
            if (result8 !== null) {
              var result6 = result8;
            } else {
              var result6 = null;
              pos = savedPos2;
            }
          }
        } else {
          var result3 = null;
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            if (input.substr(pos, 1) === "|") {
              var result5 = "|";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\"|\"");
              }
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(params) {return params})(result1[0])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_subexpression() {
        var cacheKey = 'subexpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "(") {
          var result3 = "(";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"(\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result5 = parse_expression();
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                if (input.substr(pos, 1) === ")") {
                  var result7 = ")";
                  pos += 1;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("\")\"");
                  }
                }
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(expression) {return expression})(result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_statements() {
        var cacheKey = 'statements@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos4 = pos;
        var savedPos5 = pos;
        var result22 = parse_ret();
        if (result22 !== null) {
          var result23 = [];
          if (input.substr(pos).match(/^[.]/) !== null) {
            var result24 = input.charAt(pos);
            pos++;
          } else {
            var result24 = null;
            if (reportMatchFailures) {
              matchFailed("[.]");
            }
          }
          while (result24 !== null) {
            result23.push(result24);
            if (input.substr(pos).match(/^[.]/) !== null) {
              var result24 = input.charAt(pos);
              pos++;
            } else {
              var result24 = null;
              if (reportMatchFailures) {
                matchFailed("[.]");
              }
            }
          }
          if (result23 !== null) {
            var result20 = [result22, result23];
          } else {
            var result20 = null;
            pos = savedPos5;
          }
        } else {
          var result20 = null;
          pos = savedPos5;
        }
        var result21 = result20 !== null
          ? (function(ret) {return [ret]})(result20[0])
          : null;
        if (result21 !== null) {
          var result19 = result21;
        } else {
          var result19 = null;
          pos = savedPos4;
        }
        if (result19 !== null) {
          var result0 = result19;
        } else {
          var savedPos2 = pos;
          var savedPos3 = pos;
          var result11 = parse_expressions();
          if (result11 !== null) {
            var result12 = parse_ws();
            if (result12 !== null) {
              if (input.substr(pos).match(/^[.]/) !== null) {
                var result18 = input.charAt(pos);
                pos++;
              } else {
                var result18 = null;
                if (reportMatchFailures) {
                  matchFailed("[.]");
                }
              }
              if (result18 !== null) {
                var result13 = [];
                while (result18 !== null) {
                  result13.push(result18);
                  if (input.substr(pos).match(/^[.]/) !== null) {
                    var result18 = input.charAt(pos);
                    pos++;
                  } else {
                    var result18 = null;
                    if (reportMatchFailures) {
                      matchFailed("[.]");
                    }
                  }
                }
              } else {
                var result13 = null;
              }
              if (result13 !== null) {
                var result14 = parse_ws();
                if (result14 !== null) {
                  var result15 = parse_ret();
                  if (result15 !== null) {
                    var result16 = [];
                    if (input.substr(pos).match(/^[.]/) !== null) {
                      var result17 = input.charAt(pos);
                      pos++;
                    } else {
                      var result17 = null;
                      if (reportMatchFailures) {
                        matchFailed("[.]");
                      }
                    }
                    while (result17 !== null) {
                      result16.push(result17);
                      if (input.substr(pos).match(/^[.]/) !== null) {
                        var result17 = input.charAt(pos);
                        pos++;
                      } else {
                        var result17 = null;
                        if (reportMatchFailures) {
                          matchFailed("[.]");
                        }
                      }
                    }
                    if (result16 !== null) {
                      var result9 = [result11, result12, result13, result14, result15, result16];
                    } else {
                      var result9 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result9 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result9 = null;
                  pos = savedPos3;
                }
              } else {
                var result9 = null;
                pos = savedPos3;
              }
            } else {
              var result9 = null;
              pos = savedPos3;
            }
          } else {
            var result9 = null;
            pos = savedPos3;
          }
          var result10 = result9 !== null
            ? (function(exps, ret) {
                  	      	  var expressions = exps;
                  		  expressions.push(ret);
                  		  return expressions
              		})(result9[0], result9[4])
            : null;
          if (result10 !== null) {
            var result8 = result10;
          } else {
            var result8 = null;
            pos = savedPos2;
          }
          if (result8 !== null) {
            var result0 = result8;
          } else {
            var savedPos0 = pos;
            var savedPos1 = pos;
            var result7 = parse_expressions();
            var result4 = result7 !== null ? result7 : '';
            if (result4 !== null) {
              var result5 = [];
              if (input.substr(pos).match(/^[.]/) !== null) {
                var result6 = input.charAt(pos);
                pos++;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("[.]");
                }
              }
              while (result6 !== null) {
                result5.push(result6);
                if (input.substr(pos).match(/^[.]/) !== null) {
                  var result6 = input.charAt(pos);
                  pos++;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("[.]");
                  }
                }
              }
              if (result5 !== null) {
                var result2 = [result4, result5];
              } else {
                var result2 = null;
                pos = savedPos1;
              }
            } else {
              var result2 = null;
              pos = savedPos1;
            }
            var result3 = result2 !== null
              ? (function(expressions) {
                    	          return expressions || []
                	        })(result2[0])
              : null;
            if (result3 !== null) {
              var result1 = result3;
            } else {
              var result1 = null;
              pos = savedPos0;
            }
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_sequence() {
        var cacheKey = 'sequence@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result8 = parse_temps();
        var result3 = result8 !== null ? result8 : '';
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result7 = parse_statements();
            var result5 = result7 !== null ? result7 : '';
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(temps, statements) {
          	      	  return smalltalk.SequenceNode._new()
          	      	  	._temps_(temps || [])
          	      	  	._nodes_(statements || [])
          		})(result1[0], result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_block() {
        var cacheKey = 'block@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "[") {
          var result3 = "[";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"[\"");
          }
        }
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result11 = parse_blockParamList();
            var result5 = result11 !== null ? result11 : '';
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                var result10 = parse_sequence();
                var result7 = result10 !== null ? result10 : '';
                if (result7 !== null) {
                  var result8 = parse_ws();
                  if (result8 !== null) {
                    if (input.substr(pos, 1) === "]") {
                      var result9 = "]";
                      pos += 1;
                    } else {
                      var result9 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"]\"");
                      }
                    }
                    if (result9 !== null) {
                      var result1 = [result3, result4, result5, result6, result7, result8, result9];
                    } else {
                      var result1 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(params, sequence) {
          	          return smalltalk.BlockNode._new()
          	          	._parameters_(params || [])
          	          	._nodes_([sequence._asBlockSequenceNode()])
          		})(result1[2], result1[4])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_operand() {
        var cacheKey = 'operand@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result3 = parse_literal();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_reference();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_subexpression();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_unaryMessage() {
        var cacheKey = 'unaryMessage@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result4 = parse_identifier();
          if (result4 !== null) {
            var savedPos2 = pos;
            var savedReportMatchFailuresVar0 = reportMatchFailures;
            reportMatchFailures = false;
            if (input.substr(pos).match(/^[:]/) !== null) {
              var result6 = input.charAt(pos);
              pos++;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("[:]");
              }
            }
            reportMatchFailures = savedReportMatchFailuresVar0;
            if (result6 === null) {
              var result5 = '';
            } else {
              var result5 = null;
              pos = savedPos2;
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(selector) {
          	      	return smalltalk.SendNode._new()
          	      		._selector_(selector)
          	      })(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_unaryTail() {
        var cacheKey = 'unaryTail@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_unaryMessage();
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result7 = parse_unaryTail();
            var result5 = result7 !== null ? result7 : '';
            if (result5 !== null) {
              var result6 = parse_ws();
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(message, tail) {
          		  if(tail) {
                    	      return tail._valueForReceiver_(message);
                		  }
                		  else {
                    	      return message;
                		  }
            	      })(result1[0], result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_unarySend() {
        var cacheKey = 'unarySend@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_operand();
        if (result3 !== null) {
          var result4 = parse_ws();
          if (result4 !== null) {
            var result6 = parse_unaryTail();
            var result5 = result6 !== null ? result6 : '';
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(receiver, tail) {
          		  if(tail) {
                    	      return tail._valueForReceiver_(receiver);
                		  }
                		  else {
                    	      return receiver;
                		  }
          	      })(result1[0], result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_binaryMessage() {
        var cacheKey = 'binaryMessage@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result4 = parse_binarySelector();
          if (result4 !== null) {
            var result5 = parse_ws();
            if (result5 !== null) {
              var result8 = parse_unarySend();
              if (result8 !== null) {
                var result6 = result8;
              } else {
                var result7 = parse_operand();
                if (result7 !== null) {
                  var result6 = result7;
                } else {
                  var result6 = null;;
                };
              }
              if (result6 !== null) {
                var result1 = [result3, result4, result5, result6];
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(selector, arg) {
          	          return smalltalk.SendNode._new()
          	          	._selector_(selector)
          	          	._arguments_([arg])
          	      })(result1[1], result1[3])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_binaryTail() {
        var cacheKey = 'binaryTail@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_binaryMessage();
        if (result3 !== null) {
          var result5 = parse_binaryTail();
          var result4 = result5 !== null ? result5 : '';
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(message, tail) {
                	          if(tail) {
                    	      return tail._valueForReceiver_(message);
                		  }
                		  else {
                    	      return message;
                		  }
            	      })(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_binarySend() {
        var cacheKey = 'binarySend@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_unarySend();
        if (result3 !== null) {
          var result5 = parse_binaryTail();
          var result4 = result5 !== null ? result5 : '';
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(receiver, tail) {
          	      	  if(tail) {
                    	      return tail._valueForReceiver_(receiver);
                		  }
                		  else {
                    	      return receiver;
                		  }
          	      })(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_keywordMessage() {
        var cacheKey = 'keywordMessage@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var savedPos2 = pos;
          var savedPos3 = pos;
          var result8 = parse_keywordPair();
          if (result8 !== null) {
            var result9 = parse_ws();
            if (result9 !== null) {
              var result6 = [result8, result9];
            } else {
              var result6 = null;
              pos = savedPos3;
            }
          } else {
            var result6 = null;
            pos = savedPos3;
          }
          var result7 = result6 !== null
            ? (function(pair) {return pair})(result6[0])
            : null;
          if (result7 !== null) {
            var result5 = result7;
          } else {
            var result5 = null;
            pos = savedPos2;
          }
          if (result5 !== null) {
            var result4 = [];
            while (result5 !== null) {
              result4.push(result5);
              var savedPos2 = pos;
              var savedPos3 = pos;
              var result8 = parse_keywordPair();
              if (result8 !== null) {
                var result9 = parse_ws();
                if (result9 !== null) {
                  var result6 = [result8, result9];
                } else {
                  var result6 = null;
                  pos = savedPos3;
                }
              } else {
                var result6 = null;
                pos = savedPos3;
              }
              var result7 = result6 !== null
                ? (function(pair) {return pair})(result6[0])
                : null;
              if (result7 !== null) {
                var result5 = result7;
              } else {
                var result5 = null;
                pos = savedPos2;
              }
            }
          } else {
            var result4 = null;
          }
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(pairs) {
                		  var selector = [];
                		  var args = [];
                		  for(var i=0;i<pairs.length;i++) {
                    	      selector.push(pairs[i].key);
                    	      args.push(pairs[i].arg);
                		  }
                		  return smalltalk.SendNode._new()
                		  	._selector_(selector.join(""))
                		  	._arguments_(args)
            	      })(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_keywordSend() {
        var cacheKey = 'keywordSend@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_binarySend();
        if (result3 !== null) {
          var result4 = parse_keywordMessage();
          if (result4 !== null) {
            var result1 = [result3, result4];
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(receiver, tail) {
          	          return tail._valueForReceiver_(receiver);
          	      })(result1[0], result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_message() {
        var cacheKey = 'message@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result3 = parse_binaryMessage();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_unaryMessage();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_keywordMessage();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_cascade() {
        var cacheKey = 'cascade@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result15 = parse_keywordSend();
          if (result15 !== null) {
            var result4 = result15;
          } else {
            var result14 = parse_binarySend();
            if (result14 !== null) {
              var result4 = result14;
            } else {
              var result4 = null;;
            };
          }
          if (result4 !== null) {
            var savedPos2 = pos;
            var savedPos3 = pos;
            var result9 = parse_ws();
            if (result9 !== null) {
              if (input.substr(pos, 1) === ";") {
                var result10 = ";";
                pos += 1;
              } else {
                var result10 = null;
                if (reportMatchFailures) {
                  matchFailed("\";\"");
                }
              }
              if (result10 !== null) {
                var result11 = parse_ws();
                if (result11 !== null) {
                  var result12 = parse_message();
                  if (result12 !== null) {
                    var result13 = parse_ws();
                    if (result13 !== null) {
                      var result7 = [result9, result10, result11, result12, result13];
                    } else {
                      var result7 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result7 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos3;
                }
              } else {
                var result7 = null;
                pos = savedPos3;
              }
            } else {
              var result7 = null;
              pos = savedPos3;
            }
            var result8 = result7 !== null
              ? (function(mess) {return mess})(result7[3])
              : null;
            if (result8 !== null) {
              var result6 = result8;
            } else {
              var result6 = null;
              pos = savedPos2;
            }
            if (result6 !== null) {
              var result5 = [];
              while (result6 !== null) {
                result5.push(result6);
                var savedPos2 = pos;
                var savedPos3 = pos;
                var result9 = parse_ws();
                if (result9 !== null) {
                  if (input.substr(pos, 1) === ";") {
                    var result10 = ";";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\";\"");
                    }
                  }
                  if (result10 !== null) {
                    var result11 = parse_ws();
                    if (result11 !== null) {
                      var result12 = parse_message();
                      if (result12 !== null) {
                        var result13 = parse_ws();
                        if (result13 !== null) {
                          var result7 = [result9, result10, result11, result12, result13];
                        } else {
                          var result7 = null;
                          pos = savedPos3;
                        }
                      } else {
                        var result7 = null;
                        pos = savedPos3;
                      }
                    } else {
                      var result7 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result7 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos3;
                }
                var result8 = result7 !== null
                  ? (function(mess) {return mess})(result7[3])
                  : null;
                if (result8 !== null) {
                  var result6 = result8;
                } else {
                  var result6 = null;
                  pos = savedPos2;
                }
              }
            } else {
              var result5 = null;
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(send, messages) {
          		var cascade = [];
                		cascade.push(send);
                		for(var i=0;i<messages.length;i++) {
                    		cascade.push(messages[i]);
                		}
                		return smalltalk.CascadeNode._new()
                    	       ._receiver_(send._receiver())
                    	       ._nodes_(cascade)
            	      })(result1[1], result1[2])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_jsStatement() {
        var cacheKey = 'jsStatement@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "<") {
          var result3 = "<";
          pos += 1;
        } else {
          var result3 = null;
          if (reportMatchFailures) {
            matchFailed("\"<\"");
          }
        }
        if (result3 !== null) {
          var result4 = [];
          var savedPos2 = pos;
          if (input.substr(pos, 2) === ">>") {
            var result9 = ">>";
            pos += 2;
          } else {
            var result9 = null;
            if (reportMatchFailures) {
              matchFailed("\">>\"");
            }
          }
          var result10 = result9 !== null
            ? (function() {return ">"})()
            : null;
          if (result10 !== null) {
            var result8 = result10;
          } else {
            var result8 = null;
            pos = savedPos2;
          }
          if (result8 !== null) {
            var result6 = result8;
          } else {
            if (input.substr(pos).match(/^[^>]/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^>]");
              }
            }
            if (result7 !== null) {
              var result6 = result7;
            } else {
              var result6 = null;;
            };
          }
          while (result6 !== null) {
            result4.push(result6);
            var savedPos2 = pos;
            if (input.substr(pos, 2) === ">>") {
              var result9 = ">>";
              pos += 2;
            } else {
              var result9 = null;
              if (reportMatchFailures) {
                matchFailed("\">>\"");
              }
            }
            var result10 = result9 !== null
              ? (function() {return ">"})()
              : null;
            if (result10 !== null) {
              var result8 = result10;
            } else {
              var result8 = null;
              pos = savedPos2;
            }
            if (result8 !== null) {
              var result6 = result8;
            } else {
              if (input.substr(pos).match(/^[^>]/) !== null) {
                var result7 = input.charAt(pos);
                pos++;
              } else {
                var result7 = null;
                if (reportMatchFailures) {
                  matchFailed("[^>]");
                }
              }
              if (result7 !== null) {
                var result6 = result7;
              } else {
                var result6 = null;;
              };
            }
          }
          if (result4 !== null) {
            if (input.substr(pos, 1) === ">") {
              var result5 = ">";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\">\"");
              }
            }
            if (result5 !== null) {
              var result1 = [result3, result4, result5];
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(val) {
          		return smalltalk.JSStatementNode._new()
          			._source_(val.join(""))
            	      })(result1[1])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_method() {
        var cacheKey = 'method@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var savedPos1 = pos;
        var result3 = parse_ws();
        if (result3 !== null) {
          var result11 = parse_keywordPattern();
          if (result11 !== null) {
            var result4 = result11;
          } else {
            var result10 = parse_binaryPattern();
            if (result10 !== null) {
              var result4 = result10;
            } else {
              var result9 = parse_unaryPattern();
              if (result9 !== null) {
                var result4 = result9;
              } else {
                var result4 = null;;
              };
            };
          }
          if (result4 !== null) {
            var result5 = parse_ws();
            if (result5 !== null) {
              var result8 = parse_sequence();
              var result6 = result8 !== null ? result8 : '';
              if (result6 !== null) {
                var result7 = parse_ws();
                if (result7 !== null) {
                  var result1 = [result3, result4, result5, result6, result7];
                } else {
                  var result1 = null;
                  pos = savedPos1;
                }
              } else {
                var result1 = null;
                pos = savedPos1;
              }
            } else {
              var result1 = null;
              pos = savedPos1;
            }
          } else {
            var result1 = null;
            pos = savedPos1;
          }
        } else {
          var result1 = null;
          pos = savedPos1;
        }
        var result2 = result1 !== null
          ? (function(pattern, sequence) {
          	      	return smalltalk.MethodNode._new()
          		       ._selector_(pattern[0])
          		       ._arguments_(pattern[1])
          		       ._nodes_([sequence])
          	      })(result1[1], result1[3])
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function buildErrorMessage() {
        function buildExpected(failuresExpected) {
          failuresExpected.sort();
          
          var lastFailure = null;
          var failuresExpectedUnique = [];
          for (var i = 0; i < failuresExpected.length; i++) {
            if (failuresExpected[i] !== lastFailure) {
              failuresExpectedUnique.push(failuresExpected[i]);
              lastFailure = failuresExpected[i];
            }
          }
          
          switch (failuresExpectedUnique.length) {
            case 0:
              return 'end of input';
            case 1:
              return failuresExpectedUnique[0];
            default:
              return failuresExpectedUnique.slice(0, failuresExpectedUnique.length - 1).join(', ')
                + ' or '
                + failuresExpectedUnique[failuresExpectedUnique.length - 1];
          }
        }
        
        var expected = buildExpected(rightmostMatchFailuresExpected);
        var actualPos = Math.max(pos, rightmostMatchFailuresPos);
        var actual = actualPos < input.length
          ? quote(input.charAt(actualPos))
          : 'end of input';
        
        return 'Expected ' + expected + ' but ' + actual + ' found.';
      }
      
      function computeErrorPosition() {
        /*
         * The first idea was to use |String.split| to break the input up to the
         * error position along newlines and derive the line and column from
         * there. However IE's |split| implementation is so broken that it was
         * enough to prevent it.
         */
        
        var line = 1;
        var column = 1;
        var seenCR = false;
        
        for (var i = 0; i <  rightmostMatchFailuresPos; i++) {
          var ch = input.charAt(i);
          if (ch === '\n') {
            if (!seenCR) { line++; }
            column = 1;
            seenCR = false;
          } else if (ch === '\r' | ch === '\u2028' || ch === '\u2029') {
            line++;
            column = 1;
            seenCR = true;
          } else {
            column++;
            seenCR = false;
          }
        }
        
        return { line: line, column: column };
      }
      
      
      
      var result = parseFunctions[startRule]();
      
      /*
       * The parser is now in one of the following three states:
       *
       * 1. The parser successfully parsed the whole input.
       *
       *    - |result !== null|
       *    - |pos === input.length|
       *    - |rightmostMatchFailuresExpected| may or may not contain something
       *
       * 2. The parser successfully parsed only a part of the input.
       *
       *    - |result !== null|
       *    - |pos < input.length|
       *    - |rightmostMatchFailuresExpected| may or may not contain something
       *
       * 3. The parser did not successfully parse any part of the input.
       *
       *   - |result === null|
       *   - |pos === 0|
       *   - |rightmostMatchFailuresExpected| contains at least one failure
       *
       * All code following this comment (including called functions) must
       * handle these states.
       */
      if (result === null || pos !== input.length) {
        var errorPosition = computeErrorPosition();
        throw new this.SyntaxError(
          buildErrorMessage(),
          errorPosition.line,
          errorPosition.column
        );
      }
      
      return result;
    },
    
    /* Returns the parser source code. */
    toSource: function() { return this._source; }
  };
  
  /* Thrown when a parser encounters a syntax error. */
  
  result.SyntaxError = function(message, line, column) {
    this.name = 'SyntaxError';
    this.message = message;
    this.line = line;
    this.column = column;
  };
  
  result.SyntaxError.prototype = Error.prototype;
  
  return result;
})();
