using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Security;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using UnityPlayer;

namespace WP8NativePlugin
{
    public partial class MainPage : PhoneApplicationPage
    {
        private readonly UnityApp _unityApp = new UnityApp();

        // Constructor
        [SecuritySafeCritical]
        public MainPage()
        {
            InitializeComponent();
        }
		
		private void DrawingSurface_Loaded(object sender, RoutedEventArgs e)
		{
			// Set window bounds in dips
			_unityApp.WindowBounds = new Windows.Foundation.Size(
				(float)DrawingSurface.ActualWidth,
				(float)DrawingSurface.ActualHeight
				);

			// Set native resolution in pixels
			_unityApp.NativeResolution = new Windows.Foundation.Size(
				(float)Math.Floor(DrawingSurface.ActualWidth * Application.Current.Host.Content.ScaleFactor / 100.0f + 0.5f),
				(float)Math.Floor(DrawingSurface.ActualHeight * Application.Current.Host.Content.ScaleFactor / 100.0f + 0.5f)
				);

			// Set render resolution to the full native resolution
			_unityApp.RenderResolution = _unityApp.NativeResolution;

			// Hook-up native component to DrawingSurface
			DrawingSurface.SetContentProvider(_unityApp.CreateContentProvider());
			DrawingSurface.SetManipulationHandler(_unityApp);
		}
    }
}