﻿using System;
using UnityEngine;

public class SphereScript : MonoBehaviour
{
	private bool m_IsMoving = true;
	private bool m_IsMovingLeft = false;

	public Camera GameCamera;
	public event Action<bool> SphereStateChanged;
	public bool IsSphereMoving { get { return m_IsMoving; } }

	void Start()
	{
		if (GameCamera == null)
		{
			throw new Exception("Camera is not attached to the sphere script!");
		}
	}

	void FixedUpdate()
	{
		if (!m_IsMoving)
		{
			return;
		}

		if (m_IsMovingLeft)
		{
			transform.position -= new Vector3(0.2f, 0.0f);

			if (GameCamera.WorldToScreenPoint(transform.position).x < 100.0f)
			{
				m_IsMovingLeft = false;
			}
		}
		else
		{
			transform.position += new Vector3(0.2f, 0.0f);

			if (GameCamera.WorldToScreenPoint(transform.position).x > Screen.width - 100.0f)
			{
				m_IsMovingLeft = true;
			}
		}
	}

	void OnGUI()
	{
		var buttonText = m_IsMoving ?  "Stop sphere" : "Start sphere movement";

		if (GUI.Button(new Rect(0, 0, Screen.width, 40), buttonText))
		{
			m_IsMoving = !m_IsMoving;

			if (SphereStateChanged != null)
			{
				SphereStateChanged(m_IsMoving);
			}
		}
	}
}
