using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

using UnityApp = UnityPlayer.UnityApp;
using UnityBridge = WinRTBridge.WinRTBridge;

namespace NativeBattery
{
	public partial class MainPage : PhoneApplicationPage
	{
		private bool _unityStartedLoading;
		private NativePlugin.BatteryInfo m_BatteryInfo = new NativePlugin.BatteryInfo();
		private MainScript m_MainScript;

		// Constructor
		public MainPage()
		{
			UnityApp.SetBridge(new UnityBridge());
			InitializeComponent();
		}

		private void DrawingSurfaceBackground_Loaded(object sender, RoutedEventArgs e)
		{
			if (!_unityStartedLoading)
			{
				_unityStartedLoading = true;

				UnityApp.SetLoadedCallback(Unity_Loaded);

				var content = Application.Current.Host.Content;
				var width = (int)Math.Floor(content.ActualWidth * content.ScaleFactor / 100.0 + 0.5);
				var height = (int)Math.Floor(content.ActualHeight * content.ScaleFactor / 100.0 + 0.5);

				UnityApp.SetNativeResolution(width, height);
				UnityApp.SetRenderResolution(width, height);
				UnityPlayer.UnityApp.SetOrientation((int)Orientation);

				DrawingSurfaceBackground.SetBackgroundContentProvider(UnityApp.GetBackgroundContentProvider());
				DrawingSurfaceBackground.SetBackgroundManipulationHandler(UnityApp.GetManipulationHandler());
			}
		}

		private void Unity_Loaded()
		{
			m_MainScript = (MainScript)UnityEngine.GameObject.FindObjectOfType(typeof(MainScript));
			m_MainScript.GetRemainingCharge = m_BatteryInfo.GetRemainingCharge;

			m_BatteryInfo.RemainingChargeChanged += (int charge) =>
			{
				// Unity objects must be accessed from Unity thread to prevent race conditions

				UnityApp.BeginInvoke(() =>
				{
					m_MainScript.SetRemainingCharge(charge);
				});
			};
		}

		private void PhoneApplicationPage_OrientationChanged(object sender, OrientationChangedEventArgs e)
		{
			UnityApp.SetOrientation((int)e.Orientation);
		}
	}
}