﻿using UnityEngine;

public delegate int GetRemainingChargeCallback();

public class MainScript : MonoBehaviour
{
	public GetRemainingChargeCallback GetRemainingCharge;
	private string m_Text;
	
	public void Start()
	{
		this.UpdateRemainingCharge();
	}

	public void OnGUI()
	{
		GUI.Label(new Rect(10, 10, Screen.width - 20, 30), m_Text);
		
		if (GUI.Button(new Rect(10, 50, 240, 80), "Update"))
		{
			UpdateRemainingCharge();
		}
	}
	
	private void UpdateRemainingCharge()
	{
		if (GetRemainingCharge != null)
		{
			var charge = GetRemainingCharge();
			SetRemainingCharge(charge);
		}
		else
		{
			m_Text = "Remaining battery charge: NA";
		}
	}
	
	public void SetRemainingCharge(int charge)
	{
		m_Text = string.Format("Remaining battery charge: {0}%", charge);
	}
}
