﻿using System;
using UnityEngine;

public class MainScript : MonoBehaviour
{
	public event Action buttonClicked;

	private string memoryInfo;
	private int screenWidth;

	public void Start()
	{
		this.UpdateMemoryInfo();
	}

	public void Update()
	{
		this.screenWidth = Screen.width;
	}

	public void OnGUI()
	{
		if (GUI.Button(new Rect(10, 10, screenWidth - 20, 40), "Refresh memory info"))
		{
			this.UpdateMemoryInfo();
		}

		GUI.Label(new Rect(20, 60, screenWidth - 40, 40), this.memoryInfo);

		if (GUI.Button(new Rect(10, 110, screenWidth - 20, 40), "Fire event"))
		{
			if (this.buttonClicked != null)
			{
				this.buttonClicked();
			}
		}
	}

	private void UpdateMemoryInfo()
	{
		var available = MyPlugin.AppInfo.AvailableMemory;
		var used = MyPlugin.AppInfo.UsedMemory;

		this.memoryInfo = string.Format("Available: {0} MB\nUsed: {1} MB", available, used);
	}
}
