﻿using UnityEngine;
using System.Collections;

public class Example : MonoBehaviour
{
	private static bool musicEnabled = true;
	private static bool soundEnabled = true;

	void OnGUI()
	{
		GUILayout.Label("Music " + (musicEnabled ? "enabled" : "disabled"));
		GUILayout.Label("Sound " + (soundEnabled ? "enabled" : "disabled"));
	}

	public static void SetMusicEnabled(bool enabled)
	{
		musicEnabled = enabled;
		AudioListener.volume = musicEnabled ? 1.0f : 0.0f;
	}
	public static void SetSoundEnabled(bool enabled)
	{
		soundEnabled = enabled;
	}
}
