﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.ApplicationSettings;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using UnityPlayer;

// The User Control item template is documented at http://go.microsoft.com/fwlink/?LinkId=234236

namespace Template
{
	public sealed partial class SettingsPaneContent : UserControl
	{
		public SettingsPaneContent()
		{
			this.InitializeComponent();
		}

		private void OnMusicChanged(object sender, RoutedEventArgs e)
		{
			bool isOn = ((ToggleSwitch) sender).IsOn;
			if (UnityPlayer.AppCallbacks.Instance.IsInitialized())
			{
				AppCallbacks.Instance.InvokeOnAppThread(() =>
				{
					Example.SetMusicEnabled(isOn);
				}, false);
			}
		}

		private void OnSoundChanged(object sender, RoutedEventArgs e)
		{
			bool isOn = ((ToggleSwitch)sender).IsOn;
			if (AppCallbacks.Instance.IsInitialized())
			{
				AppCallbacks.Instance.InvokeOnAppThread(() =>
				{
					Example.SetSoundEnabled(isOn);
				}, false);
			}
		}

		private void OnBackButton(object sender, RoutedEventArgs e)
		{
			Popup parent = this.Parent as Popup;
			if (parent != null)
			{
				parent.IsOpen = false;
			}

			// If the app is not snapped, then the back button shows the Settings pane again.
			if (Windows.UI.ViewManagement.ApplicationView.GetForCurrentView().IsFullScreen)
			{
				SettingsPane.Show();
			}
		}
	}
}
