/*:
 *199912
 *from diamond Garden
 *http://dgame.topcool.net
 *˵:Input.txtļ,out.txt.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define keyword_amount 3
char *keyword[2][keyword_amount]={{"Pi","E","Degree"},
	{"0.314159265359E1","0.271828182846E1","0.174532E-1"}};

/*in our DFA,we have 7 states and 6 kinds of input+other input*/
signed char table[7][7]={
	/*digit,'.','+','-','E','\n',other*/
	{1,6,-1,-1,-1,-1,-1},
	{1,2,-1,-1,-1,7,-1},
	{2,-1,-1,-1,3,7,-1},
	{5,-1,4,4,-1,7,-1},
	{5,-1,-1,-1,-1,-1,-1},
	{5,-1,-1,-1,-1,7,-1},
	{2,-1,-1,-1,-1,-1,-1}};

int string2int(char *string)
{
	int num=0,i;
	for(i=0;i<strlen(string);i++)
	{
		num=num*10+string[i]-'0';
	}
	return num;
}
void convert(char *string)
{
	/*123. 323E +43
	  ^^^  ^^^  ^^^
	  p1	p2	p3*/
	char part[64];
	int i,j;
	double num,tmp,flag;
	/*calculate part1*/
	i=0;
	while('\0'!=string[i]&&'.'!=string[i])
	{
		part[i]=string[i];
		i++;
	}
	part[i]='\0';
	num=(double)string2int(part);

	/*calcute part2*/
	j=0;
	part[0]='\0';
	if('.'==string[i])
		i++;	/*else string[i] must be '\0'*/
	while('\0'!=string[i]&&'E'!=string[i]&&'e'!=string[i])
	{
		part[j]=string[i];
		i++;
		j++;
	}
	part[j]='\0';
	tmp=0;
	for(j=j-1;j>=0;j--)
	{
		tmp=tmp/10+part[j]-'0';
	}
	num+=tmp/10;

	/*calcute part3*/
	if('E'==string[i]||'e'==string[i])
		i++;
	j=0;
	flag=10;
	if('-'==string[i])
	{
		flag=0.1;
		i++;
	}
	if('+'==string[i])
		i++;
	part[0]='\0';
	while('\0'!=string[i])
	{
		part[j]=string[i];
		i++;
		j++;
	}
	part[j]='\0';
	for(i=string2int(part);i>0;i--)
		num*=flag;
	sprintf(string,"%1.12e",num);
}
void main (int argc, char *argv[])
{
	char ch,buffer[64];
	int i,j,state,tmp;
	FILE *fin,*fout;
	char fnMat[13], fnSci[13], command[13+6];

	if (argc<2 || argc>3)
	{
                printf("none filename");
		exit(0);
	}

	strlwr(argv[1]);
	if ( strstr (argv[1], ".mat") )
		strcpy (fnMat, argv[1]);
	else
	{
		strcpy (fnMat, argv[1]);
		strcat (fnMat, ".mat");
	}

	if (argc==3)
	{
		strlwr(argv[2]);
		if ( strstr (argv[2],".sci") )
			strcpy (fnSci, argv[2]);
		else
		{
			strcpy (fnSci, argv[2]);
			strcat (fnSci, ".sci");
		}
	}
	else
	{
                        strcpy (fnSci, fnMat);
		fnSci [strlen(fnSci)-3]='s';
		fnSci [strlen(fnSci)-2]='c';
		fnSci [strlen(fnSci)-1]='i';
	}

        fin=fopen (fnMat, "r");
        fout=fopen(fnSci,"w");
	if(NULL==fin || NULL==fout)
	{
		printf("file open error.");
		exit(0);
	}

	ch=fgetc(fin);
	while(!feof(fin))
	{
		if(' '==ch || '\n'==ch)
			ch=fgetc(fin);
		else if(isalpha(ch)) /*if ch is a character*/
		{
			i=0;
			do
			{
				buffer[i]=ch;
				i++;
				ch=fgetc(fin);
			}while('\n'!=ch);
			buffer[i]='\0';
			for(i=0;i<keyword_amount;i++)
				if(!strcmp(buffer,keyword[0][i]))
				{
					strcpy(buffer,keyword[1][i]);
					fprintf(fout,"%s\n",buffer);
					break;
				}
			if(i==keyword_amount)
				fprintf(fout,"Error constant:%s\n",buffer);
		}/*endof "ch is a character"*/
		else if(isdigit(ch)||'.'==ch)
		{
			buffer[0]='\0';
			i=0;
			state=0;
			while(state!=7 && state!=-1)
			{
				/*calculate j*/
				if(isdigit(ch))
					j=0;
				else switch(ch)
				{
					case '.':j=1;break;
					case '+':j=2;break;
					case '-':j=3;break;
					case 'e':
					case 'E':j=4;break;
					case '\n':j=5;break;
					default:j=6;
				}
				tmp=table[state][j];
				if(-1==tmp)
				{
						do{
							buffer[i]=ch;
							i++;
							ch=fgetc(fin);
						}while('\n'!=ch);
						buffer[i]=ch;
						i++;
						state=-1;
				}
				else
				{
					buffer[i]=ch;
					i++;
					state=tmp;
					ch=fgetc(fin);
				}
			}/*endof state!=end*/
			buffer[i-1]='\0'; /*have a '\n' in the end*/
			if(-1==state)
				fprintf(fout,"Error constant:%s\n",buffer);
			else
			{
				convert(buffer);
				fprintf(fout,"%s\n",buffer);
			}
		}/*endof "ch is a digit"*/
		else	/*unacceptable char*/
		{
			i=0;
			do{
				buffer[i]=ch;
				i++;
				ch=fgetc(fin);
				}while('\n'!=ch);
			buffer[i]='\0';
			fprintf(fout,"Error constant:%s\n",buffer);
		}
	}/*endof while(!feof(fin))*/
}
