/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.editors;

import com.backbase.bxmleditor.editors.BILEditor;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class BILAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private static final Logger LOG;
    private String indentString = "\t";
    private BILEditor editor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.editors.BILAutoIndentStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public BILAutoIndentStrategy(BILEditor editor) {
        this.editor = editor;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c);
        } else if (c.text.equals("\t")) {
            this.singleLineIndent(d, c);
        }
    }

    public void setIndentString(int tabWidth, boolean tabsAsSpaces) {
        if (tabsAsSpaces) {
            String s = new String();
            int i = 0;
            while (i < tabWidth) {
                s = String.valueOf(s) + " ";
                ++i;
            }
            this.indentString = s;
        } else {
            this.indentString = "\t";
        }
    }

    private void singleLineIndent(IDocument d, DocumentCommand c) {
        ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        String selectedText = textSelection.getText();
        if (selectedText.length() > 0) {
            try {
                int lineOffset = d.getLineInformationOfOffset(c.offset).getOffset();
                String lineStartString = d.get(lineOffset, this.indentString.length());
                d.replace(lineOffset, this.indentString.length(), String.valueOf(this.indentString) + lineStartString);
                c.offset += this.indentString.length();
                c.text = selectedText;
            }
            catch (BadLocationException e) {
                LOG.error((Object)"BILAutoIndentStrategy :: singleLineIndent ::> \n", (Throwable)e);
            }
        } else {
            c.text = this.indentString;
        }
    }

    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int findMatchingOpenBracket(IDocument document, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = document.getLineOffset(line);
        int brackcount = this.getBracketCount(document, start, end, false) - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = document.getLineOffset(line);
            end = start + document.getLineLength(line) - 1;
            brackcount += this.getBracketCount(document, start, end, false);
        }
        return line;
    }

    private int getBracketCount(IDocument document, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int begin = start;
        int bracketcount = 0;
        block7: while (begin < end) {
            char curr = document.getChar(begin);
            ++begin;
            switch (curr) {
                case '/': {
                    if (begin >= end) break;
                    char next = document.getChar(begin);
                    if (next == '*') {
                        begin = this.getCommentEnd(document, begin + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    begin = end;
                    break;
                }
                case '*': {
                    char next;
                    if (begin >= end || (next = document.getChar(begin)) != '/') continue block7;
                    bracketcount = 0;
                    ++begin;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    begin = this.getStringEnd(document, begin, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument document, int position, int end) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char curr = document.getChar(currentPosition);
            if (curr != '*' || ++currentPosition >= end || document.getChar(currentPosition) != '/') continue;
            return currentPosition + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument document, int position, int end, char character) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char currentCharacter = document.getChar(currentPosition);
            ++currentPosition;
            if (currentCharacter == '\\') {
                ++currentPosition;
                continue;
            }
            if (currentCharacter != character) continue;
            return currentPosition;
        }
        return end;
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(command.text);
            if (command.offset < docLength && document.getChar(command.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(document, line, command.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(document, indLine));
            } else {
                int start = document.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
                buf.append(document.get(start, whiteend - start));
                if (this.getBracketCount(document, start, command.offset, true) > 0) {
                    buf.append('\t');
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException excp) {
            LOG.error((Object)"BILAutoIndentStrategy :: smartIndentAfterNewLine ::> \n", (Throwable)excp);
        }
    }

    protected void smartInsertAfterBracket(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            if (whiteend == command.offset && (indLine = this.findMatchingOpenBracket(document, line, command.offset, 1)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine));
                replaceText.append(document.get(whiteend, command.offset - whiteend));
                replaceText.append(command.text);
                command.length = command.offset - start;
                command.offset = start;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException excp) {
            LOG.error((Object)"BILAutoIndentStrategy :: smartInsertAfterBracket ::> \n", (Throwable)excp);
        }
    }
}

