/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.editors.scanners;

import com.backbase.bxmleditor.dictionary.DictionaryManager;
import com.backbase.bxmleditor.dictionary.SyntaxDictionary;
import com.backbase.bxmleditor.dictionary.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class BILPartitionScanner
extends RuleBasedPartitionScanner {
    private static final Logger LOG;
    public static final String HTML_COMMENT = "__html_comment";
    public static final String ALL_TAG = "__all_tag";
    public static final String B_TAG = "__b_tag";
    public static final String S_TAG = "__s_tag";
    public static final String SCRIPT_TAG = "__script_tag";
    public static final String CSS_TAG = "__css_tag";
    public static final String UNKNOW_TAG = "__unknow_tag";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.editors.scanners.BILPartitionScanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public BILPartitionScanner() {
        Tag tg;
        String ename;
        Iterator it;
        Set elements;
        SyntaxDictionary sd;
        Token htmlComment = new Token((Object)HTML_COMMENT);
        Token tag = new Token((Object)ALL_TAG);
        Token tag_B = new Token((Object)B_TAG);
        Token tag_S = new Token((Object)S_TAG);
        Token javascript = new Token((Object)SCRIPT_TAG);
        Token css = new Token((Object)CSS_TAG);
        Token unknowtag = new Token((Object)UNKNOW_TAG);
        ArrayList<MultiLineRule> rules = new ArrayList<MultiLineRule>();
        rules.add(new MultiLineRule("<!--", "-->", (IToken)htmlComment));
        rules.add(new MultiLineRule("<!DOCTYPE", ">", (IToken)htmlComment));
        rules.add(new MultiLineRule("<style", "</style>", (IToken)css));
        rules.add(new MultiLineRule("<STYLE", "</STYLE>", (IToken)css));
        rules.add(new MultiLineRule("<script", "</script>", (IToken)javascript));
        rules.add(new MultiLineRule("<SCRIPT", "</SCRIPT>", (IToken)javascript));
        try {
            sd = DictionaryManager.getDictionary("B_DICTIONARY");
            elements = sd.getAllElements();
            it = elements.iterator();
            while (it.hasNext()) {
                ename = (String)it.next();
                if (ename.equals("script") || ename.equals("style")) continue;
                tg = sd.getTag(ename);
                rules.add(new MultiLineRule("<b:" + ename, ">", (IToken)tag_B));
                if (tg.isSingle()) continue;
                rules.add(new MultiLineRule("</b:" + ename, ">", (IToken)tag_B));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"e :: \n", (Throwable)e);
        }
        try {
            sd = DictionaryManager.getDictionary("S_DICTIONARY");
            elements = sd.getAllElements();
            it = elements.iterator();
            while (it.hasNext()) {
                ename = (String)it.next();
                if (ename.equals("script") || ename.equals("style")) continue;
                tg = sd.getTag(ename);
                rules.add(new MultiLineRule("<s:" + ename, ">", (IToken)tag_S));
                if (tg.isSingle()) continue;
                rules.add(new MultiLineRule("</s:" + ename, ">", (IToken)tag_S));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"e :: \n", (Throwable)e);
        }
        try {
            sd = DictionaryManager.getDictionary("HTML_DICTIONARY");
            elements = sd.getAllElements();
            it = elements.iterator();
            while (it.hasNext()) {
                ename = (String)it.next();
                if (ename.equals("script") || ename.equals("style")) continue;
                tg = sd.getTag(ename);
                rules.add(new MultiLineRule("<" + ename, ">", (IToken)tag));
                rules.add(new MultiLineRule("<" + ename.toUpperCase(), ">", (IToken)tag));
                if (tg.isSingle()) continue;
                rules.add(new MultiLineRule("</" + ename, ">", (IToken)tag));
                rules.add(new MultiLineRule("</" + ename.toUpperCase(), ">", (IToken)tag));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"e :: \n", (Throwable)e);
        }
        rules.add(new MultiLineRule("<", ">", (IToken)unknowtag));
        IPredicateRule[] rulearry = new IPredicateRule[rules.size()];
        rules.toArray(rulearry);
        this.setPredicateRules(rulearry);
    }
}

