/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.editors.script;

import com.backbase.bxmleditor.dictionary.SyntaxDictionary;
import com.backbase.bxmleditor.dictionary.SyntaxDictionaryInterface;
import java.util.HashSet;
import java.util.Set;

public class JSSyntaxDictionary
extends SyntaxDictionary
implements SyntaxDictionaryInterface {
    protected static Set operators;
    protected static Set scriptkeywords;

    public JSSyntaxDictionary() {
        this.buildFunctionSyntax();
        operators = new HashSet();
        JSSyntaxDictionary.buildOperatorSyntax();
        scriptkeywords = new HashSet();
        JSSyntaxDictionary.buildScriptKeywordSyntax();
    }

    public Set getOperators() {
        return operators;
    }

    public Set getScriptKeywords() {
        return scriptkeywords;
    }

    public Set getFunctions() {
        return this.functions.keySet();
    }

    public String getFunctionUsage(String functionname) {
        return (String)this.functions.get(functionname.toLowerCase());
    }

    public Set getAllElements() {
        return null;
    }

    public Set getElementAttributes(String ele) {
        return null;
    }

    public Set getFilteredAttributes(String x, String y) {
        return null;
    }

    public Set getFilteredElements(String ele) {
        return null;
    }

    protected static void buildScriptKeywordSyntax() {
        scriptkeywords.add("for");
        scriptkeywords.add("if");
        scriptkeywords.add("else");
        scriptkeywords.add("while");
        scriptkeywords.add("return");
        scriptkeywords.add("function");
        scriptkeywords.add("var");
        scriptkeywords.add("case");
        scriptkeywords.add("do");
        scriptkeywords.add("try");
        scriptkeywords.add("catch");
        scriptkeywords.add("continue");
        scriptkeywords.add("switch");
        scriptkeywords.add("default");
        scriptkeywords.add("abstract");
        scriptkeywords.add("extends");
        scriptkeywords.add("int");
        scriptkeywords.add("super");
        scriptkeywords.add("boolean");
        scriptkeywords.add("false");
        scriptkeywords.add("interface");
        scriptkeywords.add("break");
        scriptkeywords.add("final");
        scriptkeywords.add("long");
        scriptkeywords.add("synchronized");
        scriptkeywords.add("byte");
        scriptkeywords.add("finally");
        scriptkeywords.add("native");
        scriptkeywords.add("this");
        scriptkeywords.add("float");
        scriptkeywords.add("new");
        scriptkeywords.add("throw");
        scriptkeywords.add("null");
        scriptkeywords.add("throws");
        scriptkeywords.add("char");
        scriptkeywords.add("package");
        scriptkeywords.add("transient");
        scriptkeywords.add("class");
        scriptkeywords.add("goto");
        scriptkeywords.add("true");
        scriptkeywords.add("const");
        scriptkeywords.add("protected");
        scriptkeywords.add("implements");
        scriptkeywords.add("public");
        scriptkeywords.add("import");
        scriptkeywords.add("val");
        scriptkeywords.add("short");
        scriptkeywords.add("double");
        scriptkeywords.add("instanceof");
        scriptkeywords.add("static");
        scriptkeywords.add("with");
    }

    protected static void buildOperatorSyntax() {
        operators.add("+");
        operators.add("-");
        operators.add("*");
        operators.add("/");
        operators.add("=");
        operators.add("!");
        operators.add(">");
        operators.add("<");
        operators.add("&");
        operators.add("&&");
        operators.add("|");
        operators.add("||");
        operators.add(".");
        operators.add(":");
        operators.add("?");
        operators.add("++");
        operators.add("--");
        operators.add("==");
        operators.add("!=");
        operators.add("+=");
        operators.add("-=");
        operators.add("*=");
        operators.add("/=");
        operators.add("|=");
        operators.add("<<");
        operators.add(">>");
    }

    protected void buildFunctionSyntax() {
        this.functions.put("escape", "String Escape(String)");
        this.functions.put("eval", "Object Eval(codeString)");
        this.functions.put("isFinite", "boolean isFinite(testnumber)");
        this.functions.put("isNaN", "boolean isNaN(testvalue)");
        this.functions.put("number", "number Number(Object)");
        this.functions.put("parseFloat", "float parseFloat(String)");
        this.functions.put("parseInt", "int parseInt(String, radix) || int parseInt(String)");
        this.functions.put("string", "boolean String(Object)");
        this.functions.put("unescape", "String Unescape(encodedString)");
        this.functions.put("alert", "void alert(String)");
        this.functions.put("confirm", "boolean confirm(String)");
    }
}

