/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.parser;

import com.backbase.bxmleditor.BILPlugin;
import com.backbase.bxmleditor.parser.BILDocument;
import com.backbase.bxmleditor.parser.BILNodeList;
import com.backbase.bxmleditor.parser.DocItem;
import com.backbase.bxmleditor.parser.ParseError;
import com.backbase.bxmleditor.parser.ParseMessage;
import com.backbase.bxmleditor.parser.ParseWarning;
import com.backbase.bxmleditor.parser.State;
import com.backbase.bxmleditor.parser.TagItem;
import com.backbase.bxmleditor.parser.TagMatch;
import com.backbase.bxmleditor.parser.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BILParser {
    protected static final String REG_TAG = "<(\\w*)(.*)/{0,1}>";
    protected static final String REG_ATTRIBUTES = "\\s*(\\w*)=\"([^\"]*)\"";
    protected static final int USRMSG_INFO = 0;
    protected static final int USRMSG_WARNING = 1;
    protected static final int USRMSG_ERROR = 2;
    String foo = "".toUpperCase();
    protected State parserState = null;
    protected IResource res = null;
    protected IDocument parseDoc = null;
    protected IPath docFilename = null;
    protected BILDocument parseResult = null;
    protected String data2Parse = "";
    protected int[] lineOffsets = null;
    protected static final int MATCHER_NOTHING = 0;
    protected static final int MATCHER_COMMENT = 1;
    protected static final int MATCHER_HTMLTAG = 2;
    protected static final int MATCHER_ATTRIBUTE = 4;
    protected static final int MATCHER_STRING = 100;
    protected static final int INDEX_NOTFOUND = -1;

    public BILDocument getParseResult() {
        if (this.parseResult == null) {
            // empty if block
        }
        if (this.parserState == null) {
            // empty if block
        }
        return this.parseResult;
    }

    public BILParser() {
        this.parseDoc = null;
        this.data2Parse = null;
    }

    public BILParser(IDocument doc2Parse, IResource newRes) {
        this.parseDoc = doc2Parse;
        this.data2Parse = this.parseDoc.get();
        this.res = newRes;
    }

    public BILParser(String inData, IResource dataRes) {
        this.data2Parse = inData;
        this.res = dataRes;
    }

    public ArrayList getTagMatches(IDocument inDoc) {
        ArrayList<TagMatch> matches = new ArrayList<TagMatch>();
        String inText = inDoc.get();
        Pattern pattern = Pattern.compile(REG_TAG);
        Matcher matcher = pattern.matcher(inText);
        while (matcher.find()) {
            int lineNumber = 0;
            try {
                lineNumber = inDoc.getLineOfOffset(matcher.start());
            }
            catch (BadLocationException badLocationException) {
                this.userMessage(0, "getTagMatches", "Apparently the match was out of the document!");
            }
            matches.add(new TagMatch(matcher.group(), matcher.start(), matcher.end(), lineNumber));
        }
        return matches;
    }

    protected int getLineNumber(int docOffset) {
        if (docOffset < 0) {
            return 0;
        }
        int i = 0;
        while (i < this.lineOffsets.length) {
            if (this.lineOffsets[i] > docOffset) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected boolean IsBTag(String inString) {
        return inString.indexOf("<b:") != -1;
    }

    protected boolean IsSTag(String inString) {
        return inString.indexOf("<s:") != -1;
    }

    protected void userMessage(int indent, String method, String message) {
    }

    protected void userMessage(int indent, String method, String message, int msgType, TagMatch match) {
        switch (msgType) {
            case 1: {
                this.userMessage(indent, method, "WARNING: " + message);
                break;
            }
            case 2: {
                BILPlugin.getWorkspace().getRoot();
                HashMap attrs = new HashMap();
                MarkerUtilities.setLineNumber(attrs, (int)(match.lineNumber + 1));
                MarkerUtilities.setMessage(attrs, (String)message);
                try {
                    MarkerUtilities.createMarker((IResource)this.res, attrs, (String)"org.eclipse.core.resources.problemmarker");
                }
                catch (CoreException excep) {
                    this.userMessage(0, "userMessage", "ERROR: Caught CoreException when creating a problem marker. Message: '" + excep.getMessage() + "'");
                }
                break;
            }
            default: {
                this.userMessage(indent, method, message);
            }
        }
    }

    protected HashMap stripAttributes(String inData) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(REG_ATTRIBUTES);
        Matcher matcher = pattern.matcher(inData);
        while (matcher.find()) {
            attributes.put(matcher.group(1), matcher.group(2));
        }
        return attributes;
    }

    protected boolean handleClosingTag(TagMatch match, Stack matchStack) {
        String cfr_ignored_0 = match.match;
        return true;
    }

    protected void handleHTMLTag(String tagName, TagMatch match, Stack matchStack, HashMap attrMap, boolean isACloser) {
    }

    boolean isTagACloser(String tagName, ArrayList matches, int matchPos, boolean isACloser) {
        return isACloser;
    }

    public BILDocument createDocTree(ArrayList matches) {
        BILDocument newDoc = new BILDocument();
        Stack<TagItem> matchStack = new Stack<TagItem>();
        new ArrayList();
        TagItem rootItem = new TagItem(0, 0, 0, "Doc Root");
        matchStack.push(rootItem);
        int matchPos = 0;
        try {
            while (matchPos < matches.size()) {
                TagMatch match = (TagMatch)matches.get(matchPos);
                String matchStr = match.match;
                if (matchStr.charAt(0) == '<') {
                    if (matchStr.charAt(1) == '/') {
                        if (!this.handleClosingTag(match, matchStack)) {
                            return null;
                        }
                    } else {
                        int tagEnd = matchStr.indexOf(" ");
                        if (tagEnd == -1) {
                            tagEnd = matchStr.indexOf(">");
                        }
                        String tagName = match.match.substring(0, tagEnd);
                        boolean isACloser = false;
                        int forwardSlashPos = match.match.lastIndexOf("/");
                        String attributes = "";
                        if (forwardSlashPos != -1 && match.match.charAt(forwardSlashPos + 1) == '>') {
                            if (tagName.indexOf("/") != -1) {
                                tagName = tagName.substring(0, tagName.length() - 1);
                            }
                            isACloser = true;
                            if (match.match.length() - tagEnd >= 2) {
                                attributes = match.match.substring(tagEnd, match.match.length() - 2);
                            }
                        } else {
                            attributes = match.match.substring(tagEnd, match.match.length() - 1);
                        }
                        if (this.IsBTag(tagName) || this.IsSTag(tagName)) {
                            this.handleHTMLTag(tagName, match, matchStack, this.stripAttributes(attributes), isACloser);
                        } else {
                            this.handleHTMLTag(tagName, match, matchStack, this.stripAttributes(attributes), isACloser);
                        }
                    }
                }
                ++matchPos;
            }
        }
        catch (Exception anyException) {
            this.parserState.addMessage(new ParseMessage(this.getLineNumber(matchPos), matchPos, matchPos, "", "Doc tree creation: caught an unhandled exception: " + anyException.getMessage()));
            anyException.printStackTrace();
        }
        newDoc.setDocumentRoot(rootItem);
        return newDoc;
    }

    protected int matchingHTML(State parseState, String inData, int currDocOffset) {
        int finalOffset = currDocOffset;
        int currPos = currDocOffset + 1;
        int cfTagCount = 0;
        int quoteCount = 0;
        while (currPos < inData.length()) {
            boolean inQuotes;
            char currChar = inData.charAt(currPos);
            boolean bl = inQuotes = 1 == quoteCount % 2;
            if (inData.length() - currPos > 2) {
                inData.substring(currPos + 1, currPos + 3);
            }
            if (inData.length() - currPos > 3) {
                inData.substring(currPos + 1, currPos + 4);
            }
            if (!inQuotes && currChar == '>') {
                parseState.addMatch(new TagMatch(inData.substring(currDocOffset, currPos + 1), currDocOffset, currPos, 0), 1, cfTagCount);
                finalOffset = currPos;
                break;
            }
            if (currChar == '\"') {
                ++quoteCount;
            }
            ++currPos;
        }
        if (finalOffset != currPos) {
            parseState.addMessage(new ParseError(this.getLineNumber(currDocOffset), currDocOffset, currPos, inData.substring(currDocOffset, currPos), "Reached end of document before finding end of HTML tag.", true));
        }
        return currPos;
    }

    protected ArrayList tagMatchingAttempts(String inData) {
        ArrayList matches;
        block16: {
            String data = inData;
            int currPos = 0;
            boolean currState = false;
            matches = new ArrayList();
            try {
                currPos = 0;
                while (currPos < data.length()) {
                    block18: {
                        String next2Chars;
                        char currChar;
                        block17: {
                            currChar = data.charAt(currPos);
                            next2Chars = "";
                            String next3Chars = "";
                            if (this.parserState.hadFatal()) break block16;
                            if (data.length() - currPos > 2) {
                                next2Chars = data.substring(currPos + 1, currPos + 3);
                            }
                            if (data.length() - currPos > 3) {
                                next3Chars = String.valueOf(next2Chars) + data.charAt(currPos + 3);
                            }
                            if (data.length() - currPos > 10 && currPos > 10) {
                                String cfr_ignored_0 = String.valueOf(data.substring(currPos - 10, currPos)) + data.substring(currPos, currPos + 10);
                            } else if (data.length() - currPos > 10) {
                                data.substring(currPos, currPos + 10);
                            }
                            if (currState) break block17;
                            switch (currChar) {
                                case '<': {
                                    if (next2Chars.compareTo("!-") == 0) {
                                        if (next3Chars.compareTo("!--") != 0 || data.charAt(currPos + 4) != '-') {
                                            currState = true;
                                            break;
                                        }
                                    } else if (next2Chars.compareTo("cf") != 0) {
                                        currPos = this.matchingHTML(this.parserState, inData, currPos);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block18;
                        }
                        if (currState && currChar == '-' && next2Chars.compareTo("->") == 0) {
                            currState = false;
                        }
                    }
                    ++currPos;
                }
            }
            catch (Exception exception) {
                this.parserState.addMessage(new ParseError(0, currPos, currPos, "", "Caught an exception during parsing.", true));
            }
        }
        return matches;
    }

    protected void processParseResultMessages() {
        ArrayList messages = this.parserState.getMessages();
        BILPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < messages.size()) {
            ParseMessage currMsg = (ParseMessage)messages.get(i);
            HashMap attrs = new HashMap();
            MarkerUtilities.setLineNumber(attrs, (int)(currMsg.getLineNumber() + 1));
            MarkerUtilities.setMessage(attrs, (String)currMsg.getMessage());
            if (!(currMsg instanceof ParseError)) {
                boolean cfr_ignored_0 = currMsg instanceof ParseWarning;
            }
            try {
                MarkerUtilities.createMarker((IResource)this.res, attrs, (String)"org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException excep) {
                this.userMessage(0, "userMessage", "ERROR: Caught CoreException when creating a problem marker. Message: '" + excep.getMessage() + "'");
            }
            catch (Exception anyExcep) {
                this.userMessage(0, "processParseResultMessage", "ERROR: Caught exception " + anyExcep.getMessage());
            }
            ++i;
        }
    }

    public ArrayList finalDocTreeTraversal(DocItem startNode) {
        ArrayList messages = new ArrayList();
        startNode.IsSane();
        messages.addAll(startNode.getParseState().getMessages());
        if (startNode.hasChildren()) {
            BILNodeList children = startNode.getChildNodes();
            Iterator nodeIter = children.iterator();
            while (nodeIter.hasNext()) {
                messages.addAll(this.finalDocTreeTraversal((DocItem)nodeIter.next()));
            }
        }
        return messages;
    }

    public BILDocument parseDoc(String inData) {
        BILDocument docTree = null;
        try {
            this.parserState = new State("doesn't matter!");
            this.lineOffsets = Util.calcLineNumbers(inData);
            this.tagMatchingAttempts(inData);
            docTree = this.createDocTree(this.parserState.getMatches());
            this.parserState.addMessages(this.finalDocTreeTraversal(docTree.getDocumentRoot()));
            this.processParseResultMessages();
        }
        catch (Exception exception) {}
        return docTree;
    }

    public BILDocument parseDoc() {
        if (this.parseDoc == null) {
            return this.parseDoc(this.data2Parse);
        }
        return this.parseDoc(this.parseDoc.get());
    }

    public BILDocument parseDoc(IDocument doc2Parse) {
        return this.parseDoc(doc2Parse.get());
    }
}

