/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.parser;

import com.backbase.bxmleditor.dictionary.SyntaxDictionary;
import com.backbase.bxmleditor.exceptions.InvalidChildItemException;
import com.backbase.bxmleditor.exceptions.NodeNotFound;
import com.backbase.bxmleditor.parser.BILNodeList;
import com.backbase.bxmleditor.parser.ParseError;
import com.backbase.bxmleditor.parser.ParseMessage;
import com.backbase.bxmleditor.parser.State;
import java.util.ArrayList;

public abstract class DocItem
implements Comparable {
    protected String itemName;
    protected String itemData;
    protected int lineNumber;
    protected int startPosition;
    protected int endPosition;
    public ArrayList docVariables;
    protected BILNodeList docNodes;
    protected DocItem parentNode;
    protected DocItem prevSiblingNode = null;
    protected DocItem nextSiblingNode = null;
    protected SyntaxDictionary syntax = null;
    protected State parseMessages = null;

    public void initDictionary(SyntaxDictionary newDict) {
        this.syntax = newDict;
    }

    public String getItemData() {
        return this.itemData;
    }

    public void setItemData(String data) {
        this.itemData = data;
    }

    public DocItem(int line, int startDocPos, int endDocPos, String name) {
        this.lineNumber = line;
        this.startPosition = startDocPos;
        this.endPosition = endDocPos;
        this.itemName = name;
        this.docNodes = new BILNodeList();
        this.docVariables = new ArrayList();
        this.parseMessages = new State("");
    }

    protected State getParseState() {
        return this.parseMessages;
    }

    protected void addParseMessage(ParseMessage newMsg) {
        System.out.println("DocItem::addParseMessage() - Adding message " + newMsg.getMessage());
        this.parseMessages.addMessage(newMsg);
    }

    public String getName() {
        return this.itemName;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public DocItem getMatchingItem() {
        return null;
    }

    public boolean hasChildren() {
        return this.docNodes.size() > 0;
    }

    public DocItem getFirstChild() {
        return (DocItem)this.docNodes.get(0);
    }

    public DocItem getLastChild() {
        return (DocItem)this.docNodes.get(this.docNodes.size());
    }

    public DocItem getParent() {
        return this.parentNode;
    }

    public void setParent(DocItem newParent) {
        this.parentNode = newParent;
    }

    public void setPrevSibling(DocItem newPrevSibling) {
        this.prevSiblingNode = newPrevSibling;
    }

    public void setNextSibling(DocItem newNextSibling) {
        this.nextSiblingNode = newNextSibling;
    }

    public BILNodeList getChildNodes() {
        return this.docNodes;
    }

    public ArrayList getChildren() {
        return this.docNodes;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean addChild(DocItem newItem) {
        boolean addOkay = true;
        if (!newItem.validChildAddition(this)) {
            this.parseMessages.addMessage(new ParseError(newItem.getLineNumber(), newItem.getStartPosition(), newItem.getEndPosition(), newItem.getItemData(), "Invalid child '" + newItem.getName() + "' for parent '" + this.getName() + "'"));
            addOkay = false;
        }
        newItem.setParent(newItem);
        if (this.docNodes.size() == 0) {
            newItem.setPrevSibling(null);
        } else {
            newItem.setPrevSibling((DocItem)this.docNodes.get(this.docNodes.size() - 1));
        }
        this.docNodes.add(newItem);
        return addOkay;
    }

    public void insertBefore(DocItem newChild, DocItem refChild) throws InvalidChildItemException, NodeNotFound {
        if (!newChild.validChildAddition(this)) {
            throw new InvalidChildItemException("Child item of type '" + newChild.getName() + "' says it is not allowed to belong to this ('" + this.itemName + "') doc item");
        }
        int insertPos = this.docNodes.size();
        if (refChild != null && this.docNodes.contains(refChild)) {
            insertPos = this.docNodes.indexOf(refChild);
        } else if (refChild != null) {
            throw new NodeNotFound("Cannot find node '" + refChild.getName() + "'");
        }
        this.docNodes.add(insertPos, newChild);
    }

    public DocItem removeChild(DocItem oldChild) throws NodeNotFound {
        if (!this.docNodes.remove(oldChild)) {
            throw new NodeNotFound("Cannot find node '" + oldChild.getName() + "'");
        }
        return oldChild;
    }

    public boolean validChildAddition(DocItem parentItem) {
        return false;
    }

    public BILNodeList selectNodes(String searchString) {
        BILNodeList result = new BILNodeList();
        boolean doChildNodes = false;
        String tagName = searchString;
        if (searchString.length() > 2 && searchString.charAt(0) == '/' && searchString.charAt(1) == '/') {
            doChildNodes = true;
            tagName = searchString.substring(2);
        }
        int i = 0;
        while (i < this.docNodes.size()) {
            DocItem currItem = (DocItem)this.docNodes.get(i);
            if (doChildNodes) {
                result.addAll(currItem.selectNodes(searchString));
            }
            if (currItem.getName().compareToIgnoreCase(tagName) == 0) {
                result.add(currItem);
            }
            ++i;
        }
        return result;
    }

    public boolean IsSane() {
        return true;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("DocItem compareTo got a null");
        }
        if (o instanceof DocItem) {
            return o.toString().compareTo(this.toString());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocItem && ((DocItem)obj).toString().equals(this.toString())) {
            System.err.println("we are equal: " + this.toString());
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.itemName) + ":" + this.lineNumber + ":" + this.startPosition + ":" + this.endPosition;
    }
}

