/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.parser;

import com.backbase.bxmleditor.parser.BILNodeList;
import com.backbase.bxmleditor.parser.CharOperation;
import com.backbase.bxmleditor.parser.DocItem;
import com.backbase.bxmleditor.parser.TagMatch;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class Util {
    private static final Logger LOG;
    public static String LINE_SEPARATOR;
    public static char[] LINE_SEPARATOR_CHARS;
    public static final char[] SUFFIX_class;
    public static final char[] SUFFIX_CLASS;
    public static final char[] SUFFIX_java;
    public static final char[] SUFFIX_JAVA;
    public static final char[] SUFFIX_jar;
    public static final char[] SUFFIX_JAR;
    public static final char[] SUFFIX_zip;
    public static final char[] SUFFIX_ZIP;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;
    private static final int DEFAULT_READING_SIZE = 8192;
    protected static ResourceBundle bundle;
    private static final String bundleName = "net.sourceforge.phpdt.internal.compiler.util.messages";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.parser.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        LINE_SEPARATOR = System.getProperty("line.separator");
        LINE_SEPARATOR_CHARS = LINE_SEPARATOR.toCharArray();
        SUFFIX_class = ".class".toCharArray();
        SUFFIX_CLASS = ".CLASS".toCharArray();
        SUFFIX_java = ".java".toCharArray();
        SUFFIX_JAVA = ".JAVA".toCharArray();
        SUFFIX_jar = ".jar".toCharArray();
        SUFFIX_JAR = ".JAR".toCharArray();
        SUFFIX_zip = ".zip".toCharArray();
        SUFFIX_ZIP = ".ZIP".toCharArray();
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public static String bind(String id, String binding1, String binding2) {
        return Util.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String binding) {
        return Util.bind(id, new String[]{binding});
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block9: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            if (bindings == null) {
                return message;
            }
            int length = message.length();
            int start = -1;
            int end = length;
            output = new StringBuffer(80);
            while ((end = message.indexOf(123, start)) > -1) {
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(message.substring(end + 1, start));
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(message.substring(end + 1, start + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    continue;
                }
                output.append(message.substring(end, length));
                break block9;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }

    public static String bind(String id) {
        return Util.bind(id, null);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"e :: ", (Throwable)e);
            throw e;
        }
    }

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                Object var2_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                Object var3_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(zip.getInputStream(ze));
                byArray = Util.getInputStreamAsByteArray(stream, (int)ze.getSize());
                Object var3_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_jar[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAR[suffixIndex]) {
                suffixLength = SUFFIX_ZIP.length;
                if (nameLength < suffixLength) {
                    return false;
                }
                int j = 0;
                while (j < suffixLength) {
                    c = name.charAt(nameLength - j - 1);
                    if (c != SUFFIX_zip[suffixIndex = suffixLength - j - 1] && c != SUFFIX_ZIP[suffixIndex]) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_class[suffixIndex = suffixLength - i - 1] && c != SUFFIX_CLASS[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isJavaFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_java[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAVA[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static int[] calcLineNumbers(String inputData) {
        int[] lineOffsets = null;
        int[] lineOffs = null;
        try {
            new ArrayList();
            String inText = inputData;
            Pattern pattern = Pattern.compile("(\\r\\n)");
            Matcher matcher = pattern.matcher(inText);
            if (!matcher.find(0) && !(matcher = (pattern = Pattern.compile("(\\n)")).matcher(inText)).find(0)) {
                pattern = Pattern.compile("(\\r)");
                matcher = pattern.matcher(inText);
            }
            if (matcher.find(0)) {
                int lineCnt = 0;
                while (matcher.find()) {
                    ++lineCnt;
                }
                lineOffs = new int[lineCnt + 2];
                matcher = pattern.matcher(inText);
                lineCnt = 0;
                while (matcher.find()) {
                    lineOffs[lineCnt] = matcher.end();
                    ++lineCnt;
                }
                lineOffsets = lineOffs;
            } else {
                LOG.info((Object)"Util::calcLineNumbers() - Didn't find any lines!");
                lineOffsets = new int[]{0};
            }
        }
        catch (Exception anException) {
            LOG.info((Object)("Util::calcLineNumbers() - Error, could not calculate line numbers because: " + anException.getMessage()));
        }
        return lineOffsets;
    }

    protected static int searchItemStack(Stack matchStack, String itemName) {
        int startSize = matchStack.size();
        int popCount = 0;
        Stack tempStack = new Stack();
        tempStack.copyInto(matchStack.toArray());
        while (tempStack.size() > 0) {
            DocItem tempItem = (DocItem)tempStack.pop();
            if (tempItem.getName().compareTo(itemName) == 0) break;
        }
        return startSize - popCount;
    }

    protected static void dumpMatches(ArrayList matches) {
        LOG.info((Object)"Dumping the matches:");
        int i = 0;
        while (i < matches.size()) {
            LOG.info((Object)("Match: '" + ((TagMatch)matches.get((int)i)).match + "'"));
            ++i;
        }
    }

    protected static String GetTabs(Stack inStack) {
        String retval = "";
        int i = 0;
        while (i < inStack.size()) {
            retval = String.valueOf(retval) + "\t";
            ++i;
        }
        return retval;
    }

    protected static String GetIndent(int count) {
        String retval = "";
        int i = 0;
        while (i < count) {
            retval = String.valueOf(retval) + "\t";
            ++i;
        }
        return retval;
    }

    protected static void walkTreeMain(DocItem rootItem, int count) {
        System.out.println(String.valueOf(Util.GetIndent(count)) + "Tree: " + rootItem.itemName + "' + match data was : " + rootItem.getItemData());
        if (rootItem.hasChildren()) {
            BILNodeList children = rootItem.getChildNodes();
            int i = 0;
            while (i < children.size()) {
                Util.walkTreeMain((DocItem)children.get(i), count + 1);
                ++i;
            }
        }
    }

    protected static void walkTreeNamesOnly(DocItem rootItem, int count) {
        System.out.println(String.valueOf(Util.GetIndent(count)) + rootItem.itemName);
        if (rootItem.hasChildren()) {
            BILNodeList children = rootItem.getChildNodes();
            int i = 0;
            while (i < children.size()) {
                Util.walkTreeNamesOnly((DocItem)children.get(i), count + 1);
                ++i;
            }
        }
    }

    protected static void walkTree(DocItem rootItem) {
        System.out.println("########### Tree walk 1, full info:");
        Util.walkTreeMain(rootItem, 1);
        System.out.println("########### Tree walk 2, names only:");
        Util.walkTreeNamesOnly(rootItem, 1);
    }

    protected static void dumpStack(Stack inStack) {
        int i = 0;
        while (i < inStack.size()) {
            DocItem tempItem = (DocItem)inStack.get(i);
            System.out.println("Parser: Stack at " + i + " is ', " + tempItem.itemName + "' + match data was : " + tempItem.getItemData());
            ++i;
        }
    }
}

