/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.wizards;

import com.backbase.bxmleditor.wizards.BStartBean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewBStartWizardPage
extends WizardPage {
    private Text bilTitle;
    private Text bilName;
    private ISelection selection;
    private BStartBean bstartBean;

    public NewBStartWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("New Backbase BXML startup file");
        this.setDescription("The BXML Startup file is needed to start an project.");
        this.selection = selection;
        this.bstartBean = new BStartBean();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(container, 0);
        label.setText("&Title:");
        this.bilTitle = new Text(container, 2052);
        GridData gd = new GridData(1);
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        this.bilTitle.setLayoutData((Object)gd);
        this.bilTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBStartWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.bilName = new Text(container, 2052);
        gd = new GridData(1);
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        this.bilName.setLayoutData((Object)gd);
        this.bilName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBStartWizardPage.this.dialogChanged();
            }
        });
        if (this.initialize()) {
            this.dialogChanged();
        }
        this.setControl((Control)container);
    }

    private boolean initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return false;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.bstartBean.setPath(container.getFullPath().toString());
            }
        }
        this.bstartBean.setName("BXML Untitled");
        this.bilName.setText(this.bstartBean.getName());
        return true;
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.bstartBean.setPath(((Path)result[0]).toOSString());
        }
    }

    private void handleExtendBrowse() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 65536);
        String file = fileDialog.open();
        if (file != null) {
            Path path = new Path(file);
            this.bstartBean.setPath(path.toOSString());
            this.dialogChanged();
        }
    }

    private void dialogChanged() {
        String ext;
        String containerName = this.bstartBean.getPath();
        String fileName = this.bilName.getText();
        String title = this.bilTitle.getText();
        this.bstartBean.setTitle(title);
        this.bstartBean.setName(fileName);
        this.bstartBean.setPath(containerName);
        if (containerName == null) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (containerName.length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(String.valueOf(fileName) + ".html"));
        if (file.exists()) {
            this.updateStatus("File already exists!");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc > 0 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("html")) {
            this.updateStatus("File extension will be added automatically \"html\"");
            return;
        }
        this.updateStatus(null);
    }

    private boolean validatePage() {
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public BStartBean getBStartBean() {
        return this.bstartBean;
    }
}

